# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BlockVolumeDetails(object):
    """
    Block volume that is part of the Datastore.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BlockVolumeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BlockVolumeDetails.
        :type id: str

        :param iqn:
            The value to assign to the iqn property of this BlockVolumeDetails.
        :type iqn: str

        :param attachments:
            The value to assign to the attachments property of this BlockVolumeDetails.
        :type attachments: list[oci.ocvp.models.BlockVolumeAttachment]

        """
        self.swagger_types = {
            'id': 'str',
            'iqn': 'str',
            'attachments': 'list[BlockVolumeAttachment]'
        }
        self.attribute_map = {
            'id': 'id',
            'iqn': 'iqn',
            'attachments': 'attachments'
        }
        self._id = None
        self._iqn = None
        self._attachments = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this BlockVolumeDetails.
        An `OCID`__s of the Block Storage Volume.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this BlockVolumeDetails.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BlockVolumeDetails.
        An `OCID`__s of the Block Storage Volume.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this BlockVolumeDetails.
        :type: str
        """
        self._id = id

    @property
    def iqn(self):
        """
        Gets the iqn of this BlockVolumeDetails.
        An IQN of the Block Storage Volume.


        :return: The iqn of this BlockVolumeDetails.
        :rtype: str
        """
        return self._iqn

    @iqn.setter
    def iqn(self, iqn):
        """
        Sets the iqn of this BlockVolumeDetails.
        An IQN of the Block Storage Volume.


        :param iqn: The iqn of this BlockVolumeDetails.
        :type: str
        """
        self._iqn = iqn

    @property
    def attachments(self):
        """
        Gets the attachments of this BlockVolumeDetails.
        List of BlockVolumeAttachment objects containing information about attachment details


        :return: The attachments of this BlockVolumeDetails.
        :rtype: list[oci.ocvp.models.BlockVolumeAttachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """
        Sets the attachments of this BlockVolumeDetails.
        List of BlockVolumeAttachment objects containing information about attachment details


        :param attachments: The attachments of this BlockVolumeDetails.
        :type: list[oci.ocvp.models.BlockVolumeAttachment]
        """
        self._attachments = attachments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
