# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BenchmarkDetails(object):
    """
    Benchmark test configuration detail.
    """

    #: A constant which can be used with the perf_test_length property of a BenchmarkDetails.
    #: This constant has a value of "STANDARD"
    PERF_TEST_LENGTH_STANDARD = "STANDARD"

    #: A constant which can be used with the perf_test_length property of a BenchmarkDetails.
    #: This constant has a value of "LONG"
    PERF_TEST_LENGTH_LONG = "LONG"

    def __init__(self, **kwargs):
        """
        Initializes a new BenchmarkDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param perf_test_length:
            The value to assign to the perf_test_length property of this BenchmarkDetails.
            Allowed values for this property are: "STANDARD", "LONG"
        :type perf_test_length: str

        :param control_cluster_id:
            The value to assign to the control_cluster_id property of this BenchmarkDetails.
        :type control_cluster_id: str

        :param test1_cluster_id:
            The value to assign to the test1_cluster_id property of this BenchmarkDetails.
        :type test1_cluster_id: str

        :param test2_cluster_id:
            The value to assign to the test2_cluster_id property of this BenchmarkDetails.
        :type test2_cluster_id: str

        """
        self.swagger_types = {
            'perf_test_length': 'str',
            'control_cluster_id': 'str',
            'test1_cluster_id': 'str',
            'test2_cluster_id': 'str'
        }
        self.attribute_map = {
            'perf_test_length': 'perfTestLength',
            'control_cluster_id': 'controlClusterId',
            'test1_cluster_id': 'test1ClusterId',
            'test2_cluster_id': 'test2ClusterId'
        }
        self._perf_test_length = None
        self._control_cluster_id = None
        self._test1_cluster_id = None
        self._test2_cluster_id = None

    @property
    def perf_test_length(self):
        """
        **[Required]** Gets the perf_test_length of this BenchmarkDetails.
        Execution Length of Perf Test (default set to STANDARD)

        Allowed values for this property are: "STANDARD", "LONG"


        :return: The perf_test_length of this BenchmarkDetails.
        :rtype: str
        """
        return self._perf_test_length

    @perf_test_length.setter
    def perf_test_length(self, perf_test_length):
        """
        Sets the perf_test_length of this BenchmarkDetails.
        Execution Length of Perf Test (default set to STANDARD)


        :param perf_test_length: The perf_test_length of this BenchmarkDetails.
        :type: str
        """
        allowed_values = ["STANDARD", "LONG"]
        if not value_allowed_none_or_none_sentinel(perf_test_length, allowed_values):
            raise ValueError(
                f"Invalid value for `perf_test_length`, must be None or one of {allowed_values}"
            )
        self._perf_test_length = perf_test_length

    @property
    def control_cluster_id(self):
        """
        **[Required]** Gets the control_cluster_id of this BenchmarkDetails.
        Control Cluster Id Information


        :return: The control_cluster_id of this BenchmarkDetails.
        :rtype: str
        """
        return self._control_cluster_id

    @control_cluster_id.setter
    def control_cluster_id(self, control_cluster_id):
        """
        Sets the control_cluster_id of this BenchmarkDetails.
        Control Cluster Id Information


        :param control_cluster_id: The control_cluster_id of this BenchmarkDetails.
        :type: str
        """
        self._control_cluster_id = control_cluster_id

    @property
    def test1_cluster_id(self):
        """
        Gets the test1_cluster_id of this BenchmarkDetails.
        Required Test Cluster Id needed to run perf test


        :return: The test1_cluster_id of this BenchmarkDetails.
        :rtype: str
        """
        return self._test1_cluster_id

    @test1_cluster_id.setter
    def test1_cluster_id(self, test1_cluster_id):
        """
        Sets the test1_cluster_id of this BenchmarkDetails.
        Required Test Cluster Id needed to run perf test


        :param test1_cluster_id: The test1_cluster_id of this BenchmarkDetails.
        :type: str
        """
        self._test1_cluster_id = test1_cluster_id

    @property
    def test2_cluster_id(self):
        """
        Gets the test2_cluster_id of this BenchmarkDetails.
        Optional Test Cluster Id needed to run perf test


        :return: The test2_cluster_id of this BenchmarkDetails.
        :rtype: str
        """
        return self._test2_cluster_id

    @test2_cluster_id.setter
    def test2_cluster_id(self, test2_cluster_id):
        """
        Sets the test2_cluster_id of this BenchmarkDetails.
        Optional Test Cluster Id needed to run perf test


        :param test2_cluster_id: The test2_cluster_id of this BenchmarkDetails.
        :type: str
        """
        self._test2_cluster_id = test2_cluster_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
