# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChangeExternalMysqlDatabaseInsightConnectionDetails(object):
    """
    Connection details of an External MySQL database insight.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ChangeExternalMysqlDatabaseInsightConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_connector_id:
            The value to assign to the database_connector_id property of this ChangeExternalMysqlDatabaseInsightConnectionDetails.
        :type database_connector_id: str

        """
        self.swagger_types = {
            'database_connector_id': 'str'
        }
        self.attribute_map = {
            'database_connector_id': 'databaseConnectorId'
        }
        self._database_connector_id = None

    @property
    def database_connector_id(self):
        """
        **[Required]** Gets the database_connector_id of this ChangeExternalMysqlDatabaseInsightConnectionDetails.
        The DBM owned database connector `OCID`__ mapping to the database credentials and connection details.

        __ https://docs.cloud.oracle.com/iaas/database-management/doc/view-connector-details.html


        :return: The database_connector_id of this ChangeExternalMysqlDatabaseInsightConnectionDetails.
        :rtype: str
        """
        return self._database_connector_id

    @database_connector_id.setter
    def database_connector_id(self, database_connector_id):
        """
        Sets the database_connector_id of this ChangeExternalMysqlDatabaseInsightConnectionDetails.
        The DBM owned database connector `OCID`__ mapping to the database credentials and connection details.

        __ https://docs.cloud.oracle.com/iaas/database-management/doc/view-connector-details.html


        :param database_connector_id: The database_connector_id of this ChangeExternalMysqlDatabaseInsightConnectionDetails.
        :type: str
        """
        self._database_connector_id = database_connector_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
