# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .data_object_query import DataObjectQuery
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataObjectStandardQuery(DataObjectQuery):
    """
    Information required to execute query on data objects. Query is given in standard SQL syntax providing flexibility
    to form complex queries such as queries with joins and nested queries.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataObjectStandardQuery object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.DataObjectStandardQuery.query_type` attribute
        of this class is ``STANDARD_QUERY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param query_type:
            The value to assign to the query_type property of this DataObjectStandardQuery.
            Allowed values for this property are: "TEMPLATIZED_QUERY", "STANDARD_QUERY"
        :type query_type: str

        :param bind_params:
            The value to assign to the bind_params property of this DataObjectStandardQuery.
        :type bind_params: list[oci.opsi.models.DataObjectBindParameter]

        :param query_execution_timeout_in_seconds:
            The value to assign to the query_execution_timeout_in_seconds property of this DataObjectStandardQuery.
        :type query_execution_timeout_in_seconds: float

        :param statement:
            The value to assign to the statement property of this DataObjectStandardQuery.
        :type statement: str

        :param time_filters:
            The value to assign to the time_filters property of this DataObjectStandardQuery.
        :type time_filters: oci.opsi.models.DataObjectQueryTimeFilters

        """
        self.swagger_types = {
            'query_type': 'str',
            'bind_params': 'list[DataObjectBindParameter]',
            'query_execution_timeout_in_seconds': 'float',
            'statement': 'str',
            'time_filters': 'DataObjectQueryTimeFilters'
        }
        self.attribute_map = {
            'query_type': 'queryType',
            'bind_params': 'bindParams',
            'query_execution_timeout_in_seconds': 'queryExecutionTimeoutInSeconds',
            'statement': 'statement',
            'time_filters': 'timeFilters'
        }
        self._query_type = None
        self._bind_params = None
        self._query_execution_timeout_in_seconds = None
        self._statement = None
        self._time_filters = None
        self._query_type = 'STANDARD_QUERY'

    @property
    def statement(self):
        """
        Gets the statement of this DataObjectStandardQuery.
        SQL query statement with standard Oracle supported SQL syntax.
        - When Warehouse (e.g: Awr hub) data objects are queried, use the actual names of underlying data objects (e.g: tables, views) in the query.
        The same query that works through JDBC connection with the OperationsInsightsWarehouseUsers credentials will work here and vice-versa.
        SCHEMA.VIEW syntax can also be used here.
        - When OPSI data objects are queried, use name of the respective OPSI data object, just like how views are used in a query.
        Identifier of the OPSI data object cannot be used in the query.


        :return: The statement of this DataObjectStandardQuery.
        :rtype: str
        """
        return self._statement

    @statement.setter
    def statement(self, statement):
        """
        Sets the statement of this DataObjectStandardQuery.
        SQL query statement with standard Oracle supported SQL syntax.
        - When Warehouse (e.g: Awr hub) data objects are queried, use the actual names of underlying data objects (e.g: tables, views) in the query.
        The same query that works through JDBC connection with the OperationsInsightsWarehouseUsers credentials will work here and vice-versa.
        SCHEMA.VIEW syntax can also be used here.
        - When OPSI data objects are queried, use name of the respective OPSI data object, just like how views are used in a query.
        Identifier of the OPSI data object cannot be used in the query.


        :param statement: The statement of this DataObjectStandardQuery.
        :type: str
        """
        self._statement = statement

    @property
    def time_filters(self):
        """
        Gets the time_filters of this DataObjectStandardQuery.

        :return: The time_filters of this DataObjectStandardQuery.
        :rtype: oci.opsi.models.DataObjectQueryTimeFilters
        """
        return self._time_filters

    @time_filters.setter
    def time_filters(self, time_filters):
        """
        Sets the time_filters of this DataObjectStandardQuery.

        :param time_filters: The time_filters of this DataObjectStandardQuery.
        :type: oci.opsi.models.DataObjectQueryTimeFilters
        """
        self._time_filters = time_filters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
