# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IoUsageTrendAggregation(object):
    """
    Usage data per io interface.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IoUsageTrendAggregation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param mount_point:
            The value to assign to the mount_point property of this IoUsageTrendAggregation.
        :type mount_point: str

        :param usage_data:
            The value to assign to the usage_data property of this IoUsageTrendAggregation.
        :type usage_data: list[oci.opsi.models.IoUsageTrend]

        """
        self.swagger_types = {
            'mount_point': 'str',
            'usage_data': 'list[IoUsageTrend]'
        }
        self.attribute_map = {
            'mount_point': 'mountPoint',
            'usage_data': 'usageData'
        }
        self._mount_point = None
        self._usage_data = None

    @property
    def mount_point(self):
        """
        **[Required]** Gets the mount_point of this IoUsageTrendAggregation.
        Mount point is specialized NTFS filesystem object.


        :return: The mount_point of this IoUsageTrendAggregation.
        :rtype: str
        """
        return self._mount_point

    @mount_point.setter
    def mount_point(self, mount_point):
        """
        Sets the mount_point of this IoUsageTrendAggregation.
        Mount point is specialized NTFS filesystem object.


        :param mount_point: The mount_point of this IoUsageTrendAggregation.
        :type: str
        """
        self._mount_point = mount_point

    @property
    def usage_data(self):
        """
        **[Required]** Gets the usage_data of this IoUsageTrendAggregation.
        List of usage data samples for a IO interface.


        :return: The usage_data of this IoUsageTrendAggregation.
        :rtype: list[oci.opsi.models.IoUsageTrend]
        """
        return self._usage_data

    @usage_data.setter
    def usage_data(self, usage_data):
        """
        Sets the usage_data of this IoUsageTrendAggregation.
        List of usage data samples for a IO interface.


        :param usage_data: The usage_data of this IoUsageTrendAggregation.
        :type: list[oci.opsi.models.IoUsageTrend]
        """
        self._usage_data = usage_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
