# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlSqlText(object):
    """
    MySql SQL Text type object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlSqlText object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schema_name:
            The value to assign to the schema_name property of this MySqlSqlText.
        :type schema_name: str

        :param digest:
            The value to assign to the digest property of this MySqlSqlText.
        :type digest: str

        :param time_collected:
            The value to assign to the time_collected property of this MySqlSqlText.
        :type time_collected: datetime

        :param command_type:
            The value to assign to the command_type property of this MySqlSqlText.
        :type command_type: str

        :param digest_text:
            The value to assign to the digest_text property of this MySqlSqlText.
        :type digest_text: str

        """
        self.swagger_types = {
            'schema_name': 'str',
            'digest': 'str',
            'time_collected': 'datetime',
            'command_type': 'str',
            'digest_text': 'str'
        }
        self.attribute_map = {
            'schema_name': 'schemaName',
            'digest': 'digest',
            'time_collected': 'timeCollected',
            'command_type': 'commandType',
            'digest_text': 'digestText'
        }
        self._schema_name = None
        self._digest = None
        self._time_collected = None
        self._command_type = None
        self._digest_text = None

    @property
    def schema_name(self):
        """
        Gets the schema_name of this MySqlSqlText.
        Name of Database Schema.
        Example: `\"performance_schema\"`


        :return: The schema_name of this MySqlSqlText.
        :rtype: str
        """
        return self._schema_name

    @schema_name.setter
    def schema_name(self, schema_name):
        """
        Sets the schema_name of this MySqlSqlText.
        Name of Database Schema.
        Example: `\"performance_schema\"`


        :param schema_name: The schema_name of this MySqlSqlText.
        :type: str
        """
        self._schema_name = schema_name

    @property
    def digest(self):
        """
        **[Required]** Gets the digest of this MySqlSqlText.
        digest
        Example: `\"323k3k99ua09a90adf\"`


        :return: The digest of this MySqlSqlText.
        :rtype: str
        """
        return self._digest

    @digest.setter
    def digest(self, digest):
        """
        Sets the digest of this MySqlSqlText.
        digest
        Example: `\"323k3k99ua09a90adf\"`


        :param digest: The digest of this MySqlSqlText.
        :type: str
        """
        self._digest = digest

    @property
    def time_collected(self):
        """
        **[Required]** Gets the time_collected of this MySqlSqlText.
        Collection timestamp.
        Example: `\"2020-05-06T00:00:00.000Z\"`


        :return: The time_collected of this MySqlSqlText.
        :rtype: datetime
        """
        return self._time_collected

    @time_collected.setter
    def time_collected(self, time_collected):
        """
        Sets the time_collected of this MySqlSqlText.
        Collection timestamp.
        Example: `\"2020-05-06T00:00:00.000Z\"`


        :param time_collected: The time_collected of this MySqlSqlText.
        :type: datetime
        """
        self._time_collected = time_collected

    @property
    def command_type(self):
        """
        Gets the command_type of this MySqlSqlText.
        SQL event name
        Example: `\"SELECT\"`


        :return: The command_type of this MySqlSqlText.
        :rtype: str
        """
        return self._command_type

    @command_type.setter
    def command_type(self, command_type):
        """
        Sets the command_type of this MySqlSqlText.
        SQL event name
        Example: `\"SELECT\"`


        :param command_type: The command_type of this MySqlSqlText.
        :type: str
        """
        self._command_type = command_type

    @property
    def digest_text(self):
        """
        **[Required]** Gets the digest_text of this MySqlSqlText.
        The normalized statement string.
        Example: `\"SELECT username,profile,default_tablespace,temporary_tablespace FROM dba_users\"`


        :return: The digest_text of this MySqlSqlText.
        :rtype: str
        """
        return self._digest_text

    @digest_text.setter
    def digest_text(self, digest_text):
        """
        Sets the digest_text of this MySqlSqlText.
        The normalized statement string.
        Example: `\"SELECT username,profile,default_tablespace,temporary_tablespace FROM dba_users\"`


        :param digest_text: The digest_text of this MySqlSqlText.
        :type: str
        """
        self._digest_text = digest_text

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
