# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TestMacsManagedCloudDatabaseInsightConnectionDetails(object):
    """
    Connection details of a MACS-managed cloud database .
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TestMacsManagedCloudDatabaseInsightConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param management_agent_id:
            The value to assign to the management_agent_id property of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :type management_agent_id: str

        :param connection_details:
            The value to assign to the connection_details property of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :type connection_details: oci.opsi.models.ConnectionDetails

        :param connection_credential_details:
            The value to assign to the connection_credential_details property of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :type connection_credential_details: oci.opsi.models.CredentialDetails

        """
        self.swagger_types = {
            'management_agent_id': 'str',
            'connection_details': 'ConnectionDetails',
            'connection_credential_details': 'CredentialDetails'
        }
        self.attribute_map = {
            'management_agent_id': 'managementAgentId',
            'connection_details': 'connectionDetails',
            'connection_credential_details': 'connectionCredentialDetails'
        }
        self._management_agent_id = None
        self._connection_details = None
        self._connection_credential_details = None

    @property
    def management_agent_id(self):
        """
        **[Required]** Gets the management_agent_id of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        The `OCID`__ of the Management Agent

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The management_agent_id of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :rtype: str
        """
        return self._management_agent_id

    @management_agent_id.setter
    def management_agent_id(self, management_agent_id):
        """
        Sets the management_agent_id of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        The `OCID`__ of the Management Agent

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param management_agent_id: The management_agent_id of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :type: str
        """
        self._management_agent_id = management_agent_id

    @property
    def connection_details(self):
        """
        **[Required]** Gets the connection_details of this TestMacsManagedCloudDatabaseInsightConnectionDetails.

        :return: The connection_details of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :rtype: oci.opsi.models.ConnectionDetails
        """
        return self._connection_details

    @connection_details.setter
    def connection_details(self, connection_details):
        """
        Sets the connection_details of this TestMacsManagedCloudDatabaseInsightConnectionDetails.

        :param connection_details: The connection_details of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :type: oci.opsi.models.ConnectionDetails
        """
        self._connection_details = connection_details

    @property
    def connection_credential_details(self):
        """
        **[Required]** Gets the connection_credential_details of this TestMacsManagedCloudDatabaseInsightConnectionDetails.

        :return: The connection_credential_details of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :rtype: oci.opsi.models.CredentialDetails
        """
        return self._connection_credential_details

    @connection_credential_details.setter
    def connection_credential_details(self, connection_credential_details):
        """
        Sets the connection_credential_details of this TestMacsManagedCloudDatabaseInsightConnectionDetails.

        :param connection_credential_details: The connection_credential_details of this TestMacsManagedCloudDatabaseInsightConnectionDetails.
        :type: oci.opsi.models.CredentialDetails
        """
        self._connection_credential_details = connection_credential_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
