# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .warehouse_data_object_details import WarehouseDataObjectDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WarehouseTableDataObjectDetails(WarehouseDataObjectDetails):
    """
    Details of a TABLE type data object in a Warehouse.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new WarehouseTableDataObjectDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.WarehouseTableDataObjectDetails.data_object_type` attribute
        of this class is ``TABLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_object_type:
            The value to assign to the data_object_type property of this WarehouseTableDataObjectDetails.
            Allowed values for this property are: "VIEW", "TABLE"
        :type data_object_type: str

        :param columns_metadata:
            The value to assign to the columns_metadata property of this WarehouseTableDataObjectDetails.
        :type columns_metadata: list[oci.opsi.models.DataObjectColumnMetadata]

        """
        self.swagger_types = {
            'data_object_type': 'str',
            'columns_metadata': 'list[DataObjectColumnMetadata]'
        }
        self.attribute_map = {
            'data_object_type': 'dataObjectType',
            'columns_metadata': 'columnsMetadata'
        }
        self._data_object_type = None
        self._columns_metadata = None
        self._data_object_type = 'TABLE'

    @property
    def columns_metadata(self):
        """
        Gets the columns_metadata of this WarehouseTableDataObjectDetails.
        Metadata of columns in the data object.


        :return: The columns_metadata of this WarehouseTableDataObjectDetails.
        :rtype: list[oci.opsi.models.DataObjectColumnMetadata]
        """
        return self._columns_metadata

    @columns_metadata.setter
    def columns_metadata(self, columns_metadata):
        """
        Sets the columns_metadata of this WarehouseTableDataObjectDetails.
        Metadata of columns in the data object.


        :param columns_metadata: The columns_metadata of this WarehouseTableDataObjectDetails.
        :type: list[oci.opsi.models.DataObjectColumnMetadata]
        """
        self._columns_metadata = columns_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
