# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutonomousSettings(object):
    """
    Settings for the Autonomous Linux service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AutonomousSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_data_collection_authorized:
            The value to assign to the is_data_collection_authorized property of this AutonomousSettings.
        :type is_data_collection_authorized: bool

        :param scheduled_job_id:
            The value to assign to the scheduled_job_id property of this AutonomousSettings.
        :type scheduled_job_id: str

        """
        self.swagger_types = {
            'is_data_collection_authorized': 'bool',
            'scheduled_job_id': 'str'
        }
        self.attribute_map = {
            'is_data_collection_authorized': 'isDataCollectionAuthorized',
            'scheduled_job_id': 'scheduledJobId'
        }
        self._is_data_collection_authorized = None
        self._scheduled_job_id = None

    @property
    def is_data_collection_authorized(self):
        """
        Gets the is_data_collection_authorized of this AutonomousSettings.
        Indicates whether Autonomous Linux will collect crash files. This setting can be changed by the user.


        :return: The is_data_collection_authorized of this AutonomousSettings.
        :rtype: bool
        """
        return self._is_data_collection_authorized

    @is_data_collection_authorized.setter
    def is_data_collection_authorized(self, is_data_collection_authorized):
        """
        Sets the is_data_collection_authorized of this AutonomousSettings.
        Indicates whether Autonomous Linux will collect crash files. This setting can be changed by the user.


        :param is_data_collection_authorized: The is_data_collection_authorized of this AutonomousSettings.
        :type: bool
        """
        self._is_data_collection_authorized = is_data_collection_authorized

    @property
    def scheduled_job_id(self):
        """
        Gets the scheduled_job_id of this AutonomousSettings.
        The `OCID`__ of the restricted scheduled job associated with this instance. This value cannot be deleted by the user.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The scheduled_job_id of this AutonomousSettings.
        :rtype: str
        """
        return self._scheduled_job_id

    @scheduled_job_id.setter
    def scheduled_job_id(self, scheduled_job_id):
        """
        Sets the scheduled_job_id of this AutonomousSettings.
        The `OCID`__ of the restricted scheduled job associated with this instance. This value cannot be deleted by the user.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param scheduled_job_id: The scheduled_job_id of this AutonomousSettings.
        :type: str
        """
        self._scheduled_job_id = scheduled_job_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
