# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901

from .profile import Profile
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LifecycleProfile(Profile):
    """
    Provides the information for a lifecycle environment registration profile.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LifecycleProfile object with values from keyword arguments. The default value of the :py:attr:`~oci.os_management_hub.models.LifecycleProfile.profile_type` attribute
        of this class is ``LIFECYCLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this LifecycleProfile.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this LifecycleProfile.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this LifecycleProfile.
        :type display_name: str

        :param description:
            The value to assign to the description property of this LifecycleProfile.
        :type description: str

        :param management_station_id:
            The value to assign to the management_station_id property of this LifecycleProfile.
        :type management_station_id: str

        :param profile_type:
            The value to assign to the profile_type property of this LifecycleProfile.
            Allowed values for this property are: "SOFTWARESOURCE", "GROUP", "LIFECYCLE", "STATION", "WINDOWS_STANDALONE"
        :type profile_type: str

        :param vendor_name:
            The value to assign to the vendor_name property of this LifecycleProfile.
            Allowed values for this property are: "ORACLE", "MICROSOFT"
        :type vendor_name: str

        :param os_family:
            The value to assign to the os_family property of this LifecycleProfile.
            Allowed values for this property are: "ORACLE_LINUX_9", "ORACLE_LINUX_8", "ORACLE_LINUX_7", "ORACLE_LINUX_6", "WINDOWS_SERVER_2016", "WINDOWS_SERVER_2019", "WINDOWS_SERVER_2022", "ALL"
        :type os_family: str

        :param arch_type:
            The value to assign to the arch_type property of this LifecycleProfile.
            Allowed values for this property are: "X86_64", "AARCH64", "I686", "NOARCH", "SRC", "I386"
        :type arch_type: str

        :param time_created:
            The value to assign to the time_created property of this LifecycleProfile.
        :type time_created: datetime

        :param time_modified:
            The value to assign to the time_modified property of this LifecycleProfile.
        :type time_modified: datetime

        :param profile_version:
            The value to assign to the profile_version property of this LifecycleProfile.
        :type profile_version: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this LifecycleProfile.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param registration_type:
            The value to assign to the registration_type property of this LifecycleProfile.
            Allowed values for this property are: "OCI_LINUX", "NON_OCI_LINUX", "OCI_WINDOWS", "AUTONOMOUS_LINUX"
        :type registration_type: str

        :param is_default_profile:
            The value to assign to the is_default_profile property of this LifecycleProfile.
        :type is_default_profile: bool

        :param is_service_provided_profile:
            The value to assign to the is_service_provided_profile property of this LifecycleProfile.
        :type is_service_provided_profile: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this LifecycleProfile.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this LifecycleProfile.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this LifecycleProfile.
        :type system_tags: dict(str, dict(str, object))

        :param lifecycle_environment:
            The value to assign to the lifecycle_environment property of this LifecycleProfile.
        :type lifecycle_environment: oci.os_management_hub.models.LifecycleEnvironmentDetails

        :param lifecycle_stage:
            The value to assign to the lifecycle_stage property of this LifecycleProfile.
        :type lifecycle_stage: oci.os_management_hub.models.LifecycleStageDetails

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'management_station_id': 'str',
            'profile_type': 'str',
            'vendor_name': 'str',
            'os_family': 'str',
            'arch_type': 'str',
            'time_created': 'datetime',
            'time_modified': 'datetime',
            'profile_version': 'str',
            'lifecycle_state': 'str',
            'registration_type': 'str',
            'is_default_profile': 'bool',
            'is_service_provided_profile': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'lifecycle_environment': 'LifecycleEnvironmentDetails',
            'lifecycle_stage': 'LifecycleStageDetails'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'management_station_id': 'managementStationId',
            'profile_type': 'profileType',
            'vendor_name': 'vendorName',
            'os_family': 'osFamily',
            'arch_type': 'archType',
            'time_created': 'timeCreated',
            'time_modified': 'timeModified',
            'profile_version': 'profileVersion',
            'lifecycle_state': 'lifecycleState',
            'registration_type': 'registrationType',
            'is_default_profile': 'isDefaultProfile',
            'is_service_provided_profile': 'isServiceProvidedProfile',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'lifecycle_environment': 'lifecycleEnvironment',
            'lifecycle_stage': 'lifecycleStage'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._management_station_id = None
        self._profile_type = None
        self._vendor_name = None
        self._os_family = None
        self._arch_type = None
        self._time_created = None
        self._time_modified = None
        self._profile_version = None
        self._lifecycle_state = None
        self._registration_type = None
        self._is_default_profile = None
        self._is_service_provided_profile = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._lifecycle_environment = None
        self._lifecycle_stage = None
        self._profile_type = 'LIFECYCLE'

    @property
    def lifecycle_environment(self):
        """
        Gets the lifecycle_environment of this LifecycleProfile.

        :return: The lifecycle_environment of this LifecycleProfile.
        :rtype: oci.os_management_hub.models.LifecycleEnvironmentDetails
        """
        return self._lifecycle_environment

    @lifecycle_environment.setter
    def lifecycle_environment(self, lifecycle_environment):
        """
        Sets the lifecycle_environment of this LifecycleProfile.

        :param lifecycle_environment: The lifecycle_environment of this LifecycleProfile.
        :type: oci.os_management_hub.models.LifecycleEnvironmentDetails
        """
        self._lifecycle_environment = lifecycle_environment

    @property
    def lifecycle_stage(self):
        """
        **[Required]** Gets the lifecycle_stage of this LifecycleProfile.

        :return: The lifecycle_stage of this LifecycleProfile.
        :rtype: oci.os_management_hub.models.LifecycleStageDetails
        """
        return self._lifecycle_stage

    @lifecycle_stage.setter
    def lifecycle_stage(self, lifecycle_stage):
        """
        Sets the lifecycle_stage of this LifecycleProfile.

        :param lifecycle_stage: The lifecycle_stage of this LifecycleProfile.
        :type: oci.os_management_hub.models.LifecycleStageDetails
        """
        self._lifecycle_stage = lifecycle_stage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
