# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240301


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateServiceAccessSummary(object):
    """
    A summary of private service access information. This object is returned when listing private service accesses.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateServiceAccessSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this PrivateServiceAccessSummary.
        :type compartment_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this PrivateServiceAccessSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PrivateServiceAccessSummary.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this PrivateServiceAccessSummary.
        :type system_tags: dict(str, dict(str, object))

        :param security_attributes:
            The value to assign to the security_attributes property of this PrivateServiceAccessSummary.
        :type security_attributes: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this PrivateServiceAccessSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this PrivateServiceAccessSummary.
        :type description: str

        :param id:
            The value to assign to the id property of this PrivateServiceAccessSummary.
        :type id: str

        :param time_created:
            The value to assign to the time_created property of this PrivateServiceAccessSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this PrivateServiceAccessSummary.
        :type time_updated: datetime

        :param vcn_id:
            The value to assign to the vcn_id property of this PrivateServiceAccessSummary.
        :type vcn_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this PrivateServiceAccessSummary.
        :type subnet_id: str

        :param vnic_id:
            The value to assign to the vnic_id property of this PrivateServiceAccessSummary.
        :type vnic_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PrivateServiceAccessSummary.
        :type lifecycle_state: str

        :param service_id:
            The value to assign to the service_id property of this PrivateServiceAccessSummary.
        :type service_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this PrivateServiceAccessSummary.
        :type nsg_ids: list[str]

        :param fqdns:
            The value to assign to the fqdns property of this PrivateServiceAccessSummary.
        :type fqdns: list[str]

        :param ipv4_ip:
            The value to assign to the ipv4_ip property of this PrivateServiceAccessSummary.
        :type ipv4_ip: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))',
            'security_attributes': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'description': 'str',
            'id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'vcn_id': 'str',
            'subnet_id': 'str',
            'vnic_id': 'str',
            'lifecycle_state': 'str',
            'service_id': 'str',
            'nsg_ids': 'list[str]',
            'fqdns': 'list[str]',
            'ipv4_ip': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags',
            'security_attributes': 'securityAttributes',
            'display_name': 'displayName',
            'description': 'description',
            'id': 'id',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'vcn_id': 'vcnId',
            'subnet_id': 'subnetId',
            'vnic_id': 'vnicId',
            'lifecycle_state': 'lifecycleState',
            'service_id': 'serviceId',
            'nsg_ids': 'nsgIds',
            'fqdns': 'fqdns',
            'ipv4_ip': 'ipv4Ip'
        }
        self._compartment_id = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None
        self._security_attributes = None
        self._display_name = None
        self._description = None
        self._id = None
        self._time_created = None
        self._time_updated = None
        self._vcn_id = None
        self._subnet_id = None
        self._vnic_id = None
        self._lifecycle_state = None
        self._service_id = None
        self._nsg_ids = None
        self._fqdns = None
        self._ipv4_ip = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this PrivateServiceAccessSummary.
        The `OCID`__ of the compartment that contains the
        private service access.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PrivateServiceAccessSummary.
        The `OCID`__ of the compartment that contains the
        private service access.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this PrivateServiceAccessSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this PrivateServiceAccessSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this PrivateServiceAccessSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PrivateServiceAccessSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this PrivateServiceAccessSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this PrivateServiceAccessSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this PrivateServiceAccessSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PrivateServiceAccessSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this PrivateServiceAccessSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this PrivateServiceAccessSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this PrivateServiceAccessSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PrivateServiceAccessSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this PrivateServiceAccessSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this PrivateServiceAccessSummary.
        `Security attributes`__ are labels
        for a resource that can be referenced in a `Zero Trust Packet Routing`__
        (ZPR) policy to control access to ZPR-supported resources.

        Example: `{\"Oracle-DataSecurity-ZPR\": {\"MaxEgressCount\": {\"value\":\"42\",\"mode\":\"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes
        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm


        :return: The security_attributes of this PrivateServiceAccessSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this PrivateServiceAccessSummary.
        `Security attributes`__ are labels
        for a resource that can be referenced in a `Zero Trust Packet Routing`__
        (ZPR) policy to control access to ZPR-supported resources.

        Example: `{\"Oracle-DataSecurity-ZPR\": {\"MaxEgressCount\": {\"value\":\"42\",\"mode\":\"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes
        __ https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm


        :param security_attributes: The security_attributes of this PrivateServiceAccessSummary.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PrivateServiceAccessSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PrivateServiceAccessSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this PrivateServiceAccessSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this PrivateServiceAccessSummary.
        A description of this private service access.


        :return: The description of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PrivateServiceAccessSummary.
        A description of this private service access.


        :param description: The description of this PrivateServiceAccessSummary.
        :type: str
        """
        self._description = description

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PrivateServiceAccessSummary.
        The `OCID`__ of the private service access.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PrivateServiceAccessSummary.
        The `OCID`__ of the private service access.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this PrivateServiceAccessSummary.
        :type: str
        """
        self._id = id

    @property
    def time_created(self):
        """
        Gets the time_created of this PrivateServiceAccessSummary.
        The date and time the private service access was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this PrivateServiceAccessSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PrivateServiceAccessSummary.
        The date and time the private service access was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this PrivateServiceAccessSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this PrivateServiceAccessSummary.
        The date and time the PrivateServiceAccess was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this PrivateServiceAccessSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PrivateServiceAccessSummary.
        The date and time the PrivateServiceAccess was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this PrivateServiceAccessSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this PrivateServiceAccessSummary.
        The `OCID`__ of the VCN that the private
        service access belongs to.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vcn_id of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this PrivateServiceAccessSummary.
        The `OCID`__ of the VCN that the private
        service access belongs to.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vcn_id: The vcn_id of this PrivateServiceAccessSummary.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this PrivateServiceAccessSummary.
        The `OCID`__ of the subnet that the private service access
        belongs to.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this PrivateServiceAccessSummary.
        The `OCID`__ of the subnet that the private service access
        belongs to.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this PrivateServiceAccessSummary.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def vnic_id(self):
        """
        **[Required]** Gets the vnic_id of this PrivateServiceAccessSummary.
        An `OCID`__ of the private service access's VNIC, which
        resides in the private service access's VCN .

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vnic_id of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._vnic_id

    @vnic_id.setter
    def vnic_id(self, vnic_id):
        """
        Sets the vnic_id of this PrivateServiceAccessSummary.
        An `OCID`__ of the private service access's VNIC, which
        resides in the private service access's VCN .

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vnic_id: The vnic_id of this PrivateServiceAccessSummary.
        :type: str
        """
        self._vnic_id = vnic_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this PrivateServiceAccessSummary.
        The private service access's current lifecycle state.


        :return: The lifecycle_state of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PrivateServiceAccessSummary.
        The private service access's current lifecycle state.


        :param lifecycle_state: The lifecycle_state of this PrivateServiceAccessSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def service_id(self):
        """
        **[Required]** Gets the service_id of this PrivateServiceAccessSummary.
        A unique service identifier for which the private service access was created.


        :return: The service_id of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._service_id

    @service_id.setter
    def service_id(self, service_id):
        """
        Sets the service_id of this PrivateServiceAccessSummary.
        A unique service identifier for which the private service access was created.


        :param service_id: The service_id of this PrivateServiceAccessSummary.
        :type: str
        """
        self._service_id = service_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this PrivateServiceAccessSummary.
        A list of the OCIDs of the network security groups that the private service access's VNIC belongs to.
        For more information about NSGs, see
        :class:`NetworkSecurityGroup`.


        :return: The nsg_ids of this PrivateServiceAccessSummary.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this PrivateServiceAccessSummary.
        A list of the OCIDs of the network security groups that the private service access's VNIC belongs to.
        For more information about NSGs, see
        :class:`NetworkSecurityGroup`.


        :param nsg_ids: The nsg_ids of this PrivateServiceAccessSummary.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def fqdns(self):
        """
        **[Required]** Gets the fqdns of this PrivateServiceAccessSummary.
        The private service access IPv4 FQDNs, which are going to be used to access the service.

        Example: `xyz.oraclecloud.com`


        :return: The fqdns of this PrivateServiceAccessSummary.
        :rtype: list[str]
        """
        return self._fqdns

    @fqdns.setter
    def fqdns(self, fqdns):
        """
        Sets the fqdns of this PrivateServiceAccessSummary.
        The private service access IPv4 FQDNs, which are going to be used to access the service.

        Example: `xyz.oraclecloud.com`


        :param fqdns: The fqdns of this PrivateServiceAccessSummary.
        :type: list[str]
        """
        self._fqdns = fqdns

    @property
    def ipv4_ip(self):
        """
        Gets the ipv4_ip of this PrivateServiceAccessSummary.
        The private IP address (in the consumer's VCN) that represents the access point for the
        associated service.


        :return: The ipv4_ip of this PrivateServiceAccessSummary.
        :rtype: str
        """
        return self._ipv4_ip

    @ipv4_ip.setter
    def ipv4_ip(self, ipv4_ip):
        """
        Sets the ipv4_ip of this PrivateServiceAccessSummary.
        The private IP address (in the consumer's VCN) that represents the access point for the
        associated service.


        :param ipv4_ip: The ipv4_ip of this PrivateServiceAccessSummary.
        :type: str
        """
        self._ipv4_ip = ipv4_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
