# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciCacheConfigSet(object):
    """
    Configurations for OCI Cache to manage the behavior, performance, and functionality of the underlying cache engine.
    """

    #: A constant which can be used with the lifecycle_state property of a OciCacheConfigSet.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a OciCacheConfigSet.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a OciCacheConfigSet.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a OciCacheConfigSet.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a OciCacheConfigSet.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a OciCacheConfigSet.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the software_version property of a OciCacheConfigSet.
    #: This constant has a value of "V7_0_5"
    SOFTWARE_VERSION_V7_0_5 = "V7_0_5"

    #: A constant which can be used with the software_version property of a OciCacheConfigSet.
    #: This constant has a value of "REDIS_7_0"
    SOFTWARE_VERSION_REDIS_7_0 = "REDIS_7_0"

    #: A constant which can be used with the software_version property of a OciCacheConfigSet.
    #: This constant has a value of "VALKEY_7_2"
    SOFTWARE_VERSION_VALKEY_7_2 = "VALKEY_7_2"

    def __init__(self, **kwargs):
        """
        Initializes a new OciCacheConfigSet object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OciCacheConfigSet.
        :type id: str

        :param default_config_set_id:
            The value to assign to the default_config_set_id property of this OciCacheConfigSet.
        :type default_config_set_id: str

        :param description:
            The value to assign to the description property of this OciCacheConfigSet.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this OciCacheConfigSet.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OciCacheConfigSet.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OciCacheConfigSet.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this OciCacheConfigSet.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OciCacheConfigSet.
        :type time_updated: datetime

        :param software_version:
            The value to assign to the software_version property of this OciCacheConfigSet.
            Allowed values for this property are: "V7_0_5", "REDIS_7_0", "VALKEY_7_2", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type software_version: str

        :param configuration_details:
            The value to assign to the configuration_details property of this OciCacheConfigSet.
        :type configuration_details: oci.redis.models.ConfigurationDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OciCacheConfigSet.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OciCacheConfigSet.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OciCacheConfigSet.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'default_config_set_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'software_version': 'str',
            'configuration_details': 'ConfigurationDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'default_config_set_id': 'defaultConfigSetId',
            'description': 'description',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'software_version': 'softwareVersion',
            'configuration_details': 'configurationDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._default_config_set_id = None
        self._description = None
        self._display_name = None
        self._compartment_id = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._software_version = None
        self._configuration_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OciCacheConfigSet.
        The `OCID`__ of the OCI Cache Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The id of this OciCacheConfigSet.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OciCacheConfigSet.
        The `OCID`__ of the OCI Cache Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param id: The id of this OciCacheConfigSet.
        :type: str
        """
        self._id = id

    @property
    def default_config_set_id(self):
        """
        Gets the default_config_set_id of this OciCacheConfigSet.
        The `OCID`__ of the default OCI Cache Config Set which the custom OCI Cache Config Set is based upon.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The default_config_set_id of this OciCacheConfigSet.
        :rtype: str
        """
        return self._default_config_set_id

    @default_config_set_id.setter
    def default_config_set_id(self, default_config_set_id):
        """
        Sets the default_config_set_id of this OciCacheConfigSet.
        The `OCID`__ of the default OCI Cache Config Set which the custom OCI Cache Config Set is based upon.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param default_config_set_id: The default_config_set_id of this OciCacheConfigSet.
        :type: str
        """
        self._default_config_set_id = default_config_set_id

    @property
    def description(self):
        """
        Gets the description of this OciCacheConfigSet.
        A description of the OCI Cache Config Set.


        :return: The description of this OciCacheConfigSet.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this OciCacheConfigSet.
        A description of the OCI Cache Config Set.


        :param description: The description of this OciCacheConfigSet.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this OciCacheConfigSet.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this OciCacheConfigSet.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OciCacheConfigSet.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this OciCacheConfigSet.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OciCacheConfigSet.
        The `OCID`__ of the compartment that contains the OCI Cache Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The compartment_id of this OciCacheConfigSet.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OciCacheConfigSet.
        The `OCID`__ of the compartment that contains the OCI Cache Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param compartment_id: The compartment_id of this OciCacheConfigSet.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this OciCacheConfigSet.
        The current state of the OCI Cache Config Set.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this OciCacheConfigSet.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OciCacheConfigSet.
        The current state of the OCI Cache Config Set.


        :param lifecycle_state: The lifecycle_state of this OciCacheConfigSet.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        Gets the time_created of this OciCacheConfigSet.
        The date and time the OCI Cache Config Set was created. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this OciCacheConfigSet.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OciCacheConfigSet.
        The date and time the OCI Cache Config Set was created. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this OciCacheConfigSet.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OciCacheConfigSet.
        The date and time the OCI Cache Config Set was updated. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_updated of this OciCacheConfigSet.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OciCacheConfigSet.
        The date and time the OCI Cache Config Set was updated. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_updated: The time_updated of this OciCacheConfigSet.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def software_version(self):
        """
        **[Required]** Gets the software_version of this OciCacheConfigSet.
        The OCI Cache engine version that the cluster is running.

        Allowed values for this property are: "V7_0_5", "REDIS_7_0", "VALKEY_7_2", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The software_version of this OciCacheConfigSet.
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """
        Sets the software_version of this OciCacheConfigSet.
        The OCI Cache engine version that the cluster is running.


        :param software_version: The software_version of this OciCacheConfigSet.
        :type: str
        """
        allowed_values = ["V7_0_5", "REDIS_7_0", "VALKEY_7_2"]
        if not value_allowed_none_or_none_sentinel(software_version, allowed_values):
            software_version = 'UNKNOWN_ENUM_VALUE'
        self._software_version = software_version

    @property
    def configuration_details(self):
        """
        Gets the configuration_details of this OciCacheConfigSet.

        :return: The configuration_details of this OciCacheConfigSet.
        :rtype: oci.redis.models.ConfigurationDetails
        """
        return self._configuration_details

    @configuration_details.setter
    def configuration_details(self, configuration_details):
        """
        Sets the configuration_details of this OciCacheConfigSet.

        :param configuration_details: The configuration_details of this OciCacheConfigSet.
        :type: oci.redis.models.ConfigurationDetails
        """
        self._configuration_details = configuration_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OciCacheConfigSet.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this OciCacheConfigSet.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OciCacheConfigSet.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this OciCacheConfigSet.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OciCacheConfigSet.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this OciCacheConfigSet.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OciCacheConfigSet.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this OciCacheConfigSet.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OciCacheConfigSet.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OciCacheConfigSet.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OciCacheConfigSet.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OciCacheConfigSet.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
