# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMonitoredRegionDetails(object):
    """
    The data to create a MonitoredRegion.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMonitoredRegionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_analytics_instance_id:
            The value to assign to the resource_analytics_instance_id property of this CreateMonitoredRegionDetails.
        :type resource_analytics_instance_id: str

        :param region_id:
            The value to assign to the region_id property of this CreateMonitoredRegionDetails.
        :type region_id: str

        """
        self.swagger_types = {
            'resource_analytics_instance_id': 'str',
            'region_id': 'str'
        }
        self.attribute_map = {
            'resource_analytics_instance_id': 'resourceAnalyticsInstanceId',
            'region_id': 'regionId'
        }
        self._resource_analytics_instance_id = None
        self._region_id = None

    @property
    def resource_analytics_instance_id(self):
        """
        **[Required]** Gets the resource_analytics_instance_id of this CreateMonitoredRegionDetails.
        The `OCID`__ of the ResourceAnalyticsInstance associated with this MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_analytics_instance_id of this CreateMonitoredRegionDetails.
        :rtype: str
        """
        return self._resource_analytics_instance_id

    @resource_analytics_instance_id.setter
    def resource_analytics_instance_id(self, resource_analytics_instance_id):
        """
        Sets the resource_analytics_instance_id of this CreateMonitoredRegionDetails.
        The `OCID`__ of the ResourceAnalyticsInstance associated with this MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_analytics_instance_id: The resource_analytics_instance_id of this CreateMonitoredRegionDetails.
        :type: str
        """
        self._resource_analytics_instance_id = resource_analytics_instance_id

    @property
    def region_id(self):
        """
        **[Required]** Gets the region_id of this CreateMonitoredRegionDetails.
        The `Region Identifier`__ of this MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm


        :return: The region_id of this CreateMonitoredRegionDetails.
        :rtype: str
        """
        return self._region_id

    @region_id.setter
    def region_id(self, region_id):
        """
        Sets the region_id of this CreateMonitoredRegionDetails.
        The `Region Identifier`__ of this MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm


        :param region_id: The region_id of this CreateMonitoredRegionDetails.
        :type: str
        """
        self._region_id = region_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
