# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MonitoredRegion(object):
    """
    A MonitoredRegion is a region to collect data for the associated ResourceAnalyticsInstance.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a MonitoredRegion.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a MonitoredRegion.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a MonitoredRegion.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a MonitoredRegion.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a MonitoredRegion.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a MonitoredRegion.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new MonitoredRegion object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MonitoredRegion.
        :type id: str

        :param resource_analytics_instance_id:
            The value to assign to the resource_analytics_instance_id property of this MonitoredRegion.
        :type resource_analytics_instance_id: str

        :param region_id:
            The value to assign to the region_id property of this MonitoredRegion.
        :type region_id: str

        :param time_created:
            The value to assign to the time_created property of this MonitoredRegion.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this MonitoredRegion.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this MonitoredRegion.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this MonitoredRegion.
        :type lifecycle_details: str

        :param system_tags:
            The value to assign to the system_tags property of this MonitoredRegion.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'resource_analytics_instance_id': 'str',
            'region_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'resource_analytics_instance_id': 'resourceAnalyticsInstanceId',
            'region_id': 'regionId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._resource_analytics_instance_id = None
        self._region_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this MonitoredRegion.
        The `OCID`__ of the MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this MonitoredRegion.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MonitoredRegion.
        The `OCID`__ of the MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this MonitoredRegion.
        :type: str
        """
        self._id = id

    @property
    def resource_analytics_instance_id(self):
        """
        **[Required]** Gets the resource_analytics_instance_id of this MonitoredRegion.
        The `OCID`__ of the ResourceAnalyticsInstance associated with this MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_analytics_instance_id of this MonitoredRegion.
        :rtype: str
        """
        return self._resource_analytics_instance_id

    @resource_analytics_instance_id.setter
    def resource_analytics_instance_id(self, resource_analytics_instance_id):
        """
        Sets the resource_analytics_instance_id of this MonitoredRegion.
        The `OCID`__ of the ResourceAnalyticsInstance associated with this MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_analytics_instance_id: The resource_analytics_instance_id of this MonitoredRegion.
        :type: str
        """
        self._resource_analytics_instance_id = resource_analytics_instance_id

    @property
    def region_id(self):
        """
        **[Required]** Gets the region_id of this MonitoredRegion.
        The `Region Identifier`__ of this MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm


        :return: The region_id of this MonitoredRegion.
        :rtype: str
        """
        return self._region_id

    @region_id.setter
    def region_id(self, region_id):
        """
        Sets the region_id of this MonitoredRegion.
        The `Region Identifier`__ of this MonitoredRegion.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm


        :param region_id: The region_id of this MonitoredRegion.
        :type: str
        """
        self._region_id = region_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MonitoredRegion.
        The date and time the MonitoredRegion was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this MonitoredRegion.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MonitoredRegion.
        The date and time the MonitoredRegion was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this MonitoredRegion.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this MonitoredRegion.
        The date and time the MonitoredRegion was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this MonitoredRegion.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this MonitoredRegion.
        The date and time the MonitoredRegion was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this MonitoredRegion.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this MonitoredRegion.
        The current state of the MonitoredRegion.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this MonitoredRegion.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this MonitoredRegion.
        The current state of the MonitoredRegion.


        :param lifecycle_state: The lifecycle_state of this MonitoredRegion.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this MonitoredRegion.
        A message that describes the current state of the MonitoredRegion in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this MonitoredRegion.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this MonitoredRegion.
        A message that describes the current state of the MonitoredRegion in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this MonitoredRegion.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def system_tags(self):
        """
        Gets the system_tags of this MonitoredRegion.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this MonitoredRegion.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this MonitoredRegion.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this MonitoredRegion.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
