# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceAnalyticsInstanceOacAttachmentDetails(object):
    """
    Additional details needed when attaching the OAC instance.

    Example: `{\"idcsDomainId\":\"ocid...\",\"networkDetails\":{...}, ...}`
    """

    #: A constant which can be used with the license_model property of a ResourceAnalyticsInstanceOacAttachmentDetails.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a ResourceAnalyticsInstanceOacAttachmentDetails.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceAnalyticsInstanceOacAttachmentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param idcs_domain_id:
            The value to assign to the idcs_domain_id property of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type idcs_domain_id: str

        :param network_details:
            The value to assign to the network_details property of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type network_details: oci.resource_analytics.models.ResourceAnalyticsInstanceOacNetworkDetails

        :param subnet_id:
            The value to assign to the subnet_id property of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type nsg_ids: list[str]

        :param license_model:
            The value to assign to the license_model property of this ResourceAnalyticsInstanceOacAttachmentDetails.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"
        :type license_model: str

        """
        self.swagger_types = {
            'idcs_domain_id': 'str',
            'network_details': 'ResourceAnalyticsInstanceOacNetworkDetails',
            'subnet_id': 'str',
            'nsg_ids': 'list[str]',
            'license_model': 'str'
        }
        self.attribute_map = {
            'idcs_domain_id': 'idcsDomainId',
            'network_details': 'networkDetails',
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds',
            'license_model': 'licenseModel'
        }
        self._idcs_domain_id = None
        self._network_details = None
        self._subnet_id = None
        self._nsg_ids = None
        self._license_model = None

    @property
    def idcs_domain_id(self):
        """
        **[Required]** Gets the idcs_domain_id of this ResourceAnalyticsInstanceOacAttachmentDetails.
        IDCS domain `OCID`__ identifying a stripe and service administrator user.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The idcs_domain_id of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :rtype: str
        """
        return self._idcs_domain_id

    @idcs_domain_id.setter
    def idcs_domain_id(self, idcs_domain_id):
        """
        Sets the idcs_domain_id of this ResourceAnalyticsInstanceOacAttachmentDetails.
        IDCS domain `OCID`__ identifying a stripe and service administrator user.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param idcs_domain_id: The idcs_domain_id of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type: str
        """
        self._idcs_domain_id = idcs_domain_id

    @property
    def network_details(self):
        """
        Gets the network_details of this ResourceAnalyticsInstanceOacAttachmentDetails.

        :return: The network_details of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :rtype: oci.resource_analytics.models.ResourceAnalyticsInstanceOacNetworkDetails
        """
        return self._network_details

    @network_details.setter
    def network_details(self, network_details):
        """
        Sets the network_details of this ResourceAnalyticsInstanceOacAttachmentDetails.

        :param network_details: The network_details of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type: oci.resource_analytics.models.ResourceAnalyticsInstanceOacNetworkDetails
        """
        self._network_details = network_details

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this ResourceAnalyticsInstanceOacAttachmentDetails.
        Deprecated. Use `networkDetails.subnetId` instead.


        :return: The subnet_id of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this ResourceAnalyticsInstanceOacAttachmentDetails.
        Deprecated. Use `networkDetails.subnetId` instead.


        :param subnet_id: The subnet_id of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this ResourceAnalyticsInstanceOacAttachmentDetails.
        Deprecated. Use `networkDetails.nsgIds` instead.


        :return: The nsg_ids of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this ResourceAnalyticsInstanceOacAttachmentDetails.
        Deprecated. Use `networkDetails.nsgIds` instead.


        :param nsg_ids: The nsg_ids of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def license_model(self):
        """
        Gets the license_model of this ResourceAnalyticsInstanceOacAttachmentDetails.
        The Oracle license model that applies to the OAC instance.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"


        :return: The license_model of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this ResourceAnalyticsInstanceOacAttachmentDetails.
        The Oracle license model that applies to the OAC instance.


        :param license_model: The license_model of this ResourceAnalyticsInstanceOacAttachmentDetails.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            raise ValueError(
                f"Invalid value for `license_model`, must be None or one of {allowed_values}"
            )
        self._license_model = license_model

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
