# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentExtensionHandlerConfiguration(object):
    """
    Specific resource mapping configurations for Agent Extension Handlers.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgentExtensionHandlerConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param collector_types:
            The value to assign to the collector_types property of this AgentExtensionHandlerConfiguration.
        :type collector_types: list[str]

        :param metric_upload_interval_in_seconds:
            The value to assign to the metric_upload_interval_in_seconds property of this AgentExtensionHandlerConfiguration.
        :type metric_upload_interval_in_seconds: int

        :param telemetry_resource_group:
            The value to assign to the telemetry_resource_group property of this AgentExtensionHandlerConfiguration.
        :type telemetry_resource_group: str

        :param telegraf_resource_name_config:
            The value to assign to the telegraf_resource_name_config property of this AgentExtensionHandlerConfiguration.
        :type telegraf_resource_name_config: oci.stack_monitoring.models.TelegrafResourceNameConfigurationDetails

        :param collectd_resource_name_config:
            The value to assign to the collectd_resource_name_config property of this AgentExtensionHandlerConfiguration.
        :type collectd_resource_name_config: oci.stack_monitoring.models.CollectdResourceNameConfigurationDetails

        :param metric_name_config:
            The value to assign to the metric_name_config property of this AgentExtensionHandlerConfiguration.
        :type metric_name_config: oci.stack_monitoring.models.MetricNameConfigurationDetails

        :param metric_mappings:
            The value to assign to the metric_mappings property of this AgentExtensionHandlerConfiguration.
        :type metric_mappings: list[oci.stack_monitoring.models.AgentExtensionHandlerMetricMappingDetails]

        :param handler_properties:
            The value to assign to the handler_properties property of this AgentExtensionHandlerConfiguration.
        :type handler_properties: list[oci.stack_monitoring.models.AgentExtensionHandlerConfigurationProperty]

        """
        self.swagger_types = {
            'collector_types': 'list[str]',
            'metric_upload_interval_in_seconds': 'int',
            'telemetry_resource_group': 'str',
            'telegraf_resource_name_config': 'TelegrafResourceNameConfigurationDetails',
            'collectd_resource_name_config': 'CollectdResourceNameConfigurationDetails',
            'metric_name_config': 'MetricNameConfigurationDetails',
            'metric_mappings': 'list[AgentExtensionHandlerMetricMappingDetails]',
            'handler_properties': 'list[AgentExtensionHandlerConfigurationProperty]'
        }
        self.attribute_map = {
            'collector_types': 'collectorTypes',
            'metric_upload_interval_in_seconds': 'metricUploadIntervalInSeconds',
            'telemetry_resource_group': 'telemetryResourceGroup',
            'telegraf_resource_name_config': 'telegrafResourceNameConfig',
            'collectd_resource_name_config': 'collectdResourceNameConfig',
            'metric_name_config': 'metricNameConfig',
            'metric_mappings': 'metricMappings',
            'handler_properties': 'handlerProperties'
        }
        self._collector_types = None
        self._metric_upload_interval_in_seconds = None
        self._telemetry_resource_group = None
        self._telegraf_resource_name_config = None
        self._collectd_resource_name_config = None
        self._metric_name_config = None
        self._metric_mappings = None
        self._handler_properties = None

    @property
    def collector_types(self):
        """
        **[Required]** Gets the collector_types of this AgentExtensionHandlerConfiguration.
        List of collector/plugin names.


        :return: The collector_types of this AgentExtensionHandlerConfiguration.
        :rtype: list[str]
        """
        return self._collector_types

    @collector_types.setter
    def collector_types(self, collector_types):
        """
        Sets the collector_types of this AgentExtensionHandlerConfiguration.
        List of collector/plugin names.


        :param collector_types: The collector_types of this AgentExtensionHandlerConfiguration.
        :type: list[str]
        """
        self._collector_types = collector_types

    @property
    def metric_upload_interval_in_seconds(self):
        """
        Gets the metric_upload_interval_in_seconds of this AgentExtensionHandlerConfiguration.
        Metric upload interval in seconds. Any metric sent by telegraf/collectd before the
        configured interval expires will be dropped.


        :return: The metric_upload_interval_in_seconds of this AgentExtensionHandlerConfiguration.
        :rtype: int
        """
        return self._metric_upload_interval_in_seconds

    @metric_upload_interval_in_seconds.setter
    def metric_upload_interval_in_seconds(self, metric_upload_interval_in_seconds):
        """
        Sets the metric_upload_interval_in_seconds of this AgentExtensionHandlerConfiguration.
        Metric upload interval in seconds. Any metric sent by telegraf/collectd before the
        configured interval expires will be dropped.


        :param metric_upload_interval_in_seconds: The metric_upload_interval_in_seconds of this AgentExtensionHandlerConfiguration.
        :type: int
        """
        self._metric_upload_interval_in_seconds = metric_upload_interval_in_seconds

    @property
    def telemetry_resource_group(self):
        """
        Gets the telemetry_resource_group of this AgentExtensionHandlerConfiguration.
        Resource group string; if not specified, the resource group string will be generated by the handler.


        :return: The telemetry_resource_group of this AgentExtensionHandlerConfiguration.
        :rtype: str
        """
        return self._telemetry_resource_group

    @telemetry_resource_group.setter
    def telemetry_resource_group(self, telemetry_resource_group):
        """
        Sets the telemetry_resource_group of this AgentExtensionHandlerConfiguration.
        Resource group string; if not specified, the resource group string will be generated by the handler.


        :param telemetry_resource_group: The telemetry_resource_group of this AgentExtensionHandlerConfiguration.
        :type: str
        """
        self._telemetry_resource_group = telemetry_resource_group

    @property
    def telegraf_resource_name_config(self):
        """
        Gets the telegraf_resource_name_config of this AgentExtensionHandlerConfiguration.

        :return: The telegraf_resource_name_config of this AgentExtensionHandlerConfiguration.
        :rtype: oci.stack_monitoring.models.TelegrafResourceNameConfigurationDetails
        """
        return self._telegraf_resource_name_config

    @telegraf_resource_name_config.setter
    def telegraf_resource_name_config(self, telegraf_resource_name_config):
        """
        Sets the telegraf_resource_name_config of this AgentExtensionHandlerConfiguration.

        :param telegraf_resource_name_config: The telegraf_resource_name_config of this AgentExtensionHandlerConfiguration.
        :type: oci.stack_monitoring.models.TelegrafResourceNameConfigurationDetails
        """
        self._telegraf_resource_name_config = telegraf_resource_name_config

    @property
    def collectd_resource_name_config(self):
        """
        Gets the collectd_resource_name_config of this AgentExtensionHandlerConfiguration.

        :return: The collectd_resource_name_config of this AgentExtensionHandlerConfiguration.
        :rtype: oci.stack_monitoring.models.CollectdResourceNameConfigurationDetails
        """
        return self._collectd_resource_name_config

    @collectd_resource_name_config.setter
    def collectd_resource_name_config(self, collectd_resource_name_config):
        """
        Sets the collectd_resource_name_config of this AgentExtensionHandlerConfiguration.

        :param collectd_resource_name_config: The collectd_resource_name_config of this AgentExtensionHandlerConfiguration.
        :type: oci.stack_monitoring.models.CollectdResourceNameConfigurationDetails
        """
        self._collectd_resource_name_config = collectd_resource_name_config

    @property
    def metric_name_config(self):
        """
        Gets the metric_name_config of this AgentExtensionHandlerConfiguration.

        :return: The metric_name_config of this AgentExtensionHandlerConfiguration.
        :rtype: oci.stack_monitoring.models.MetricNameConfigurationDetails
        """
        return self._metric_name_config

    @metric_name_config.setter
    def metric_name_config(self, metric_name_config):
        """
        Sets the metric_name_config of this AgentExtensionHandlerConfiguration.

        :param metric_name_config: The metric_name_config of this AgentExtensionHandlerConfiguration.
        :type: oci.stack_monitoring.models.MetricNameConfigurationDetails
        """
        self._metric_name_config = metric_name_config

    @property
    def metric_mappings(self):
        """
        Gets the metric_mappings of this AgentExtensionHandlerConfiguration.
        List of AgentExtensionHandlerMetricMappingDetails.


        :return: The metric_mappings of this AgentExtensionHandlerConfiguration.
        :rtype: list[oci.stack_monitoring.models.AgentExtensionHandlerMetricMappingDetails]
        """
        return self._metric_mappings

    @metric_mappings.setter
    def metric_mappings(self, metric_mappings):
        """
        Sets the metric_mappings of this AgentExtensionHandlerConfiguration.
        List of AgentExtensionHandlerMetricMappingDetails.


        :param metric_mappings: The metric_mappings of this AgentExtensionHandlerConfiguration.
        :type: list[oci.stack_monitoring.models.AgentExtensionHandlerMetricMappingDetails]
        """
        self._metric_mappings = metric_mappings

    @property
    def handler_properties(self):
        """
        Gets the handler_properties of this AgentExtensionHandlerConfiguration.
        List of handler configuration properties


        :return: The handler_properties of this AgentExtensionHandlerConfiguration.
        :rtype: list[oci.stack_monitoring.models.AgentExtensionHandlerConfigurationProperty]
        """
        return self._handler_properties

    @handler_properties.setter
    def handler_properties(self, handler_properties):
        """
        Sets the handler_properties of this AgentExtensionHandlerConfiguration.
        List of handler configuration properties


        :param handler_properties: The handler_properties of this AgentExtensionHandlerConfiguration.
        :type: list[oci.stack_monitoring.models.AgentExtensionHandlerConfigurationProperty]
        """
        self._handler_properties = handler_properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
