# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AnomalyMetricData(object):
    """
    Anomaly Metric Details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AnomalyMetricData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param dimensions:
            The value to assign to the dimensions property of this AnomalyMetricData.
        :type dimensions: dict(str, str)

        :param data_points:
            The value to assign to the data_points property of this AnomalyMetricData.
        :type data_points: list[oci.stack_monitoring.models.AnomalyDataPoint]

        """
        self.swagger_types = {
            'dimensions': 'dict(str, str)',
            'data_points': 'list[AnomalyDataPoint]'
        }
        self.attribute_map = {
            'dimensions': 'dimensions',
            'data_points': 'dataPoints'
        }
        self._dimensions = None
        self._data_points = None

    @property
    def dimensions(self):
        """
        Gets the dimensions of this AnomalyMetricData.
        list of dimensions for the metric


        :return: The dimensions of this AnomalyMetricData.
        :rtype: dict(str, str)
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this AnomalyMetricData.
        list of dimensions for the metric


        :param dimensions: The dimensions of this AnomalyMetricData.
        :type: dict(str, str)
        """
        self._dimensions = dimensions

    @property
    def data_points(self):
        """
        **[Required]** Gets the data_points of this AnomalyMetricData.
        list of anomaly data points for the metric


        :return: The data_points of this AnomalyMetricData.
        :rtype: list[oci.stack_monitoring.models.AnomalyDataPoint]
        """
        return self._data_points

    @data_points.setter
    def data_points(self, data_points):
        """
        Sets the data_points of this AnomalyMetricData.
        list of anomaly data points for the metric


        :param data_points: The data_points of this AnomalyMetricData.
        :type: list[oci.stack_monitoring.models.AnomalyDataPoint]
        """
        self._data_points = data_points

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
