# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceWindowSchedule(object):
    """
    Schedule information of the Maintenance Window
    """

    #: A constant which can be used with the schedule_type property of a MaintenanceWindowSchedule.
    #: This constant has a value of "ONE_TIME"
    SCHEDULE_TYPE_ONE_TIME = "ONE_TIME"

    #: A constant which can be used with the schedule_type property of a MaintenanceWindowSchedule.
    #: This constant has a value of "RECURRENT"
    SCHEDULE_TYPE_RECURRENT = "RECURRENT"

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceWindowSchedule object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.stack_monitoring.models.RecurrentMaintenanceWindowSchedule`
        * :class:`~oci.stack_monitoring.models.OneTimeMaintenanceWindowSchedule`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schedule_type:
            The value to assign to the schedule_type property of this MaintenanceWindowSchedule.
            Allowed values for this property are: "ONE_TIME", "RECURRENT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type schedule_type: str

        """
        self.swagger_types = {
            'schedule_type': 'str'
        }
        self.attribute_map = {
            'schedule_type': 'scheduleType'
        }
        self._schedule_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['scheduleType']

        if type == 'RECURRENT':
            return 'RecurrentMaintenanceWindowSchedule'

        if type == 'ONE_TIME':
            return 'OneTimeMaintenanceWindowSchedule'
        else:
            return 'MaintenanceWindowSchedule'

    @property
    def schedule_type(self):
        """
        **[Required]** Gets the schedule_type of this MaintenanceWindowSchedule.
        Property to identify the type of the Maintenance Window.

        Allowed values for this property are: "ONE_TIME", "RECURRENT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The schedule_type of this MaintenanceWindowSchedule.
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """
        Sets the schedule_type of this MaintenanceWindowSchedule.
        Property to identify the type of the Maintenance Window.


        :param schedule_type: The schedule_type of this MaintenanceWindowSchedule.
        :type: str
        """
        allowed_values = ["ONE_TIME", "RECURRENT"]
        if not value_allowed_none_or_none_sentinel(schedule_type, allowed_values):
            schedule_type = 'UNKNOWN_ENUM_VALUE'
        self._schedule_type = schedule_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
