# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MemberReference(object):
    """
    The Member Reference details
    """

    #: A constant which can be used with the type property of a MemberReference.
    #: This constant has a value of "RESOURCE_INSTANCE"
    TYPE_RESOURCE_INSTANCE = "RESOURCE_INSTANCE"

    #: A constant which can be used with the type property of a MemberReference.
    #: This constant has a value of "RESOURCE_TYPE"
    TYPE_RESOURCE_TYPE = "RESOURCE_TYPE"

    #: A constant which can be used with the type property of a MemberReference.
    #: This constant has a value of "RESOURCE_GROUP"
    TYPE_RESOURCE_GROUP = "RESOURCE_GROUP"

    def __init__(self, **kwargs):
        """
        Initializes a new MemberReference object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MemberReference.
        :type id: str

        :param type:
            The value to assign to the type property of this MemberReference.
            Allowed values for this property are: "RESOURCE_INSTANCE", "RESOURCE_TYPE", "RESOURCE_GROUP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param composite_type:
            The value to assign to the composite_type property of this MemberReference.
        :type composite_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str',
            'composite_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'type': 'type',
            'composite_type': 'compositeType'
        }
        self._id = None
        self._type = None
        self._composite_type = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this MemberReference.
        The OCID of the resourceInstance/resourceType/resourceGroup


        :return: The id of this MemberReference.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MemberReference.
        The OCID of the resourceInstance/resourceType/resourceGroup


        :param id: The id of this MemberReference.
        :type: str
        """
        self._id = id

    @property
    def type(self):
        """
        **[Required]** Gets the type of this MemberReference.
        Type of the member reference RESOURCE_INSTANCE, RESOURCE_TYPE, RESOURCE_GROUP

        Allowed values for this property are: "RESOURCE_INSTANCE", "RESOURCE_TYPE", "RESOURCE_GROUP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this MemberReference.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this MemberReference.
        Type of the member reference RESOURCE_INSTANCE, RESOURCE_TYPE, RESOURCE_GROUP


        :param type: The type of this MemberReference.
        :type: str
        """
        allowed_values = ["RESOURCE_INSTANCE", "RESOURCE_TYPE", "RESOURCE_GROUP"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def composite_type(self):
        """
        Gets the composite_type of this MemberReference.
        The OCID of the composite resource type like EBS or Peoplesoft.


        :return: The composite_type of this MemberReference.
        :rtype: str
        """
        return self._composite_type

    @composite_type.setter
    def composite_type(self, composite_type):
        """
        Sets the composite_type of this MemberReference.
        The OCID of the composite resource type like EBS or Peoplesoft.


        :param composite_type: The composite_type of this MemberReference.
        :type: str
        """
        self._composite_type = composite_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
