# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAlarmConditionDetails(object):
    """
    The information about updating a alarm condition in the same monitoringTemplate in a compartment.
    """

    #: A constant which can be used with the condition_type property of a UpdateAlarmConditionDetails.
    #: This constant has a value of "FIXED"
    CONDITION_TYPE_FIXED = "FIXED"

    #: A constant which can be used with the condition_type property of a UpdateAlarmConditionDetails.
    #: This constant has a value of "AVAILABILITY"
    CONDITION_TYPE_AVAILABILITY = "AVAILABILITY"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAlarmConditionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param namespace:
            The value to assign to the namespace property of this UpdateAlarmConditionDetails.
        :type namespace: str

        :param composite_type:
            The value to assign to the composite_type property of this UpdateAlarmConditionDetails.
        :type composite_type: str

        :param resource_type:
            The value to assign to the resource_type property of this UpdateAlarmConditionDetails.
        :type resource_type: str

        :param metric_name:
            The value to assign to the metric_name property of this UpdateAlarmConditionDetails.
        :type metric_name: str

        :param condition_type:
            The value to assign to the condition_type property of this UpdateAlarmConditionDetails.
            Allowed values for this property are: "FIXED", "AVAILABILITY"
        :type condition_type: str

        :param conditions:
            The value to assign to the conditions property of this UpdateAlarmConditionDetails.
        :type conditions: list[oci.stack_monitoring.models.Condition]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAlarmConditionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAlarmConditionDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'namespace': 'str',
            'composite_type': 'str',
            'resource_type': 'str',
            'metric_name': 'str',
            'condition_type': 'str',
            'conditions': 'list[Condition]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'namespace': 'namespace',
            'composite_type': 'compositeType',
            'resource_type': 'resourceType',
            'metric_name': 'metricName',
            'condition_type': 'conditionType',
            'conditions': 'conditions',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._namespace = None
        self._composite_type = None
        self._resource_type = None
        self._metric_name = None
        self._condition_type = None
        self._conditions = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def namespace(self):
        """
        Gets the namespace of this UpdateAlarmConditionDetails.
        The stack monitoring service or application emitting the metric that is evaluated by the alarm.


        :return: The namespace of this UpdateAlarmConditionDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this UpdateAlarmConditionDetails.
        The stack monitoring service or application emitting the metric that is evaluated by the alarm.


        :param namespace: The namespace of this UpdateAlarmConditionDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def composite_type(self):
        """
        Gets the composite_type of this UpdateAlarmConditionDetails.
        The OCID of composite resource type like EBS/PEOPLE_SOFT.


        :return: The composite_type of this UpdateAlarmConditionDetails.
        :rtype: str
        """
        return self._composite_type

    @composite_type.setter
    def composite_type(self, composite_type):
        """
        Sets the composite_type of this UpdateAlarmConditionDetails.
        The OCID of composite resource type like EBS/PEOPLE_SOFT.


        :param composite_type: The composite_type of this UpdateAlarmConditionDetails.
        :type: str
        """
        self._composite_type = composite_type

    @property
    def resource_type(self):
        """
        Gets the resource_type of this UpdateAlarmConditionDetails.
        The resource type OCID.


        :return: The resource_type of this UpdateAlarmConditionDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this UpdateAlarmConditionDetails.
        The resource type OCID.


        :param resource_type: The resource_type of this UpdateAlarmConditionDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def metric_name(self):
        """
        Gets the metric_name of this UpdateAlarmConditionDetails.
        The metric name.


        :return: The metric_name of this UpdateAlarmConditionDetails.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this UpdateAlarmConditionDetails.
        The metric name.


        :param metric_name: The metric_name of this UpdateAlarmConditionDetails.
        :type: str
        """
        self._metric_name = metric_name

    @property
    def condition_type(self):
        """
        Gets the condition_type of this UpdateAlarmConditionDetails.
        Type of defined monitoring template.

        Allowed values for this property are: "FIXED", "AVAILABILITY"


        :return: The condition_type of this UpdateAlarmConditionDetails.
        :rtype: str
        """
        return self._condition_type

    @condition_type.setter
    def condition_type(self, condition_type):
        """
        Sets the condition_type of this UpdateAlarmConditionDetails.
        Type of defined monitoring template.


        :param condition_type: The condition_type of this UpdateAlarmConditionDetails.
        :type: str
        """
        allowed_values = ["FIXED", "AVAILABILITY"]
        if not value_allowed_none_or_none_sentinel(condition_type, allowed_values):
            raise ValueError(
                f"Invalid value for `condition_type`, must be None or one of {allowed_values}"
            )
        self._condition_type = condition_type

    @property
    def conditions(self):
        """
        Gets the conditions of this UpdateAlarmConditionDetails.
        Monitoring template conditions


        :return: The conditions of this UpdateAlarmConditionDetails.
        :rtype: list[oci.stack_monitoring.models.Condition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """
        Sets the conditions of this UpdateAlarmConditionDetails.
        Monitoring template conditions


        :param conditions: The conditions of this UpdateAlarmConditionDetails.
        :type: list[oci.stack_monitoring.models.Condition]
        """
        self._conditions = conditions

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateAlarmConditionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateAlarmConditionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateAlarmConditionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateAlarmConditionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateAlarmConditionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateAlarmConditionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateAlarmConditionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateAlarmConditionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
