# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RequestUsageCarbonEmissionsDetails(object):
    """
    Details for the '/usageCarbonEmissions' query.
    """

    #: A constant which can be used with the emission_calculation_method property of a RequestUsageCarbonEmissionsDetails.
    #: This constant has a value of "SPEND_BASED"
    EMISSION_CALCULATION_METHOD_SPEND_BASED = "SPEND_BASED"

    #: A constant which can be used with the emission_calculation_method property of a RequestUsageCarbonEmissionsDetails.
    #: This constant has a value of "POWER_BASED"
    EMISSION_CALCULATION_METHOD_POWER_BASED = "POWER_BASED"

    #: A constant which can be used with the emission_type property of a RequestUsageCarbonEmissionsDetails.
    #: This constant has a value of "MARKET_BASED"
    EMISSION_TYPE_MARKET_BASED = "MARKET_BASED"

    #: A constant which can be used with the emission_type property of a RequestUsageCarbonEmissionsDetails.
    #: This constant has a value of "LOCATION_BASED"
    EMISSION_TYPE_LOCATION_BASED = "LOCATION_BASED"

    #: A constant which can be used with the granularity property of a RequestUsageCarbonEmissionsDetails.
    #: This constant has a value of "DAILY"
    GRANULARITY_DAILY = "DAILY"

    #: A constant which can be used with the granularity property of a RequestUsageCarbonEmissionsDetails.
    #: This constant has a value of "MONTHLY"
    GRANULARITY_MONTHLY = "MONTHLY"

    def __init__(self, **kwargs):
        """
        Initializes a new RequestUsageCarbonEmissionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tenant_id:
            The value to assign to the tenant_id property of this RequestUsageCarbonEmissionsDetails.
        :type tenant_id: str

        :param time_usage_started:
            The value to assign to the time_usage_started property of this RequestUsageCarbonEmissionsDetails.
        :type time_usage_started: datetime

        :param time_usage_ended:
            The value to assign to the time_usage_ended property of this RequestUsageCarbonEmissionsDetails.
        :type time_usage_ended: datetime

        :param emission_calculation_method:
            The value to assign to the emission_calculation_method property of this RequestUsageCarbonEmissionsDetails.
            Allowed values for this property are: "SPEND_BASED", "POWER_BASED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type emission_calculation_method: str

        :param emission_type:
            The value to assign to the emission_type property of this RequestUsageCarbonEmissionsDetails.
            Allowed values for this property are: "MARKET_BASED", "LOCATION_BASED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type emission_type: str

        :param granularity:
            The value to assign to the granularity property of this RequestUsageCarbonEmissionsDetails.
            Allowed values for this property are: "DAILY", "MONTHLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type granularity: str

        :param is_aggregate_by_time:
            The value to assign to the is_aggregate_by_time property of this RequestUsageCarbonEmissionsDetails.
        :type is_aggregate_by_time: bool

        :param group_by:
            The value to assign to the group_by property of this RequestUsageCarbonEmissionsDetails.
        :type group_by: list[str]

        :param group_by_tag:
            The value to assign to the group_by_tag property of this RequestUsageCarbonEmissionsDetails.
        :type group_by_tag: list[oci.usage_api.models.Tag]

        :param compartment_depth:
            The value to assign to the compartment_depth property of this RequestUsageCarbonEmissionsDetails.
        :type compartment_depth: int

        :param filter:
            The value to assign to the filter property of this RequestUsageCarbonEmissionsDetails.
        :type filter: oci.usage_api.models.Filter

        """
        self.swagger_types = {
            'tenant_id': 'str',
            'time_usage_started': 'datetime',
            'time_usage_ended': 'datetime',
            'emission_calculation_method': 'str',
            'emission_type': 'str',
            'granularity': 'str',
            'is_aggregate_by_time': 'bool',
            'group_by': 'list[str]',
            'group_by_tag': 'list[Tag]',
            'compartment_depth': 'int',
            'filter': 'Filter'
        }
        self.attribute_map = {
            'tenant_id': 'tenantId',
            'time_usage_started': 'timeUsageStarted',
            'time_usage_ended': 'timeUsageEnded',
            'emission_calculation_method': 'emissionCalculationMethod',
            'emission_type': 'emissionType',
            'granularity': 'granularity',
            'is_aggregate_by_time': 'isAggregateByTime',
            'group_by': 'groupBy',
            'group_by_tag': 'groupByTag',
            'compartment_depth': 'compartmentDepth',
            'filter': 'filter'
        }
        self._tenant_id = None
        self._time_usage_started = None
        self._time_usage_ended = None
        self._emission_calculation_method = None
        self._emission_type = None
        self._granularity = None
        self._is_aggregate_by_time = None
        self._group_by = None
        self._group_by_tag = None
        self._compartment_depth = None
        self._filter = None

    @property
    def tenant_id(self):
        """
        **[Required]** Gets the tenant_id of this RequestUsageCarbonEmissionsDetails.
        Tenant ID.


        :return: The tenant_id of this RequestUsageCarbonEmissionsDetails.
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """
        Sets the tenant_id of this RequestUsageCarbonEmissionsDetails.
        Tenant ID.


        :param tenant_id: The tenant_id of this RequestUsageCarbonEmissionsDetails.
        :type: str
        """
        self._tenant_id = tenant_id

    @property
    def time_usage_started(self):
        """
        **[Required]** Gets the time_usage_started of this RequestUsageCarbonEmissionsDetails.
        The usage start time.


        :return: The time_usage_started of this RequestUsageCarbonEmissionsDetails.
        :rtype: datetime
        """
        return self._time_usage_started

    @time_usage_started.setter
    def time_usage_started(self, time_usage_started):
        """
        Sets the time_usage_started of this RequestUsageCarbonEmissionsDetails.
        The usage start time.


        :param time_usage_started: The time_usage_started of this RequestUsageCarbonEmissionsDetails.
        :type: datetime
        """
        self._time_usage_started = time_usage_started

    @property
    def time_usage_ended(self):
        """
        **[Required]** Gets the time_usage_ended of this RequestUsageCarbonEmissionsDetails.
        The usage end time.


        :return: The time_usage_ended of this RequestUsageCarbonEmissionsDetails.
        :rtype: datetime
        """
        return self._time_usage_ended

    @time_usage_ended.setter
    def time_usage_ended(self, time_usage_ended):
        """
        Sets the time_usage_ended of this RequestUsageCarbonEmissionsDetails.
        The usage end time.


        :param time_usage_ended: The time_usage_ended of this RequestUsageCarbonEmissionsDetails.
        :type: datetime
        """
        self._time_usage_ended = time_usage_ended

    @property
    def emission_calculation_method(self):
        """
        Gets the emission_calculation_method of this RequestUsageCarbonEmissionsDetails.
        Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED

        Allowed values for this property are: "SPEND_BASED", "POWER_BASED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The emission_calculation_method of this RequestUsageCarbonEmissionsDetails.
        :rtype: str
        """
        return self._emission_calculation_method

    @emission_calculation_method.setter
    def emission_calculation_method(self, emission_calculation_method):
        """
        Sets the emission_calculation_method of this RequestUsageCarbonEmissionsDetails.
        Specifies the method used for emission calculation, such as POWER_BASED or SPEND_BASED


        :param emission_calculation_method: The emission_calculation_method of this RequestUsageCarbonEmissionsDetails.
        :type: str
        """
        allowed_values = ["SPEND_BASED", "POWER_BASED"]
        if not value_allowed_none_or_none_sentinel(emission_calculation_method, allowed_values):
            emission_calculation_method = 'UNKNOWN_ENUM_VALUE'
        self._emission_calculation_method = emission_calculation_method

    @property
    def emission_type(self):
        """
        Gets the emission_type of this RequestUsageCarbonEmissionsDetails.
        Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.

        Allowed values for this property are: "MARKET_BASED", "LOCATION_BASED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The emission_type of this RequestUsageCarbonEmissionsDetails.
        :rtype: str
        """
        return self._emission_type

    @emission_type.setter
    def emission_type(self, emission_type):
        """
        Sets the emission_type of this RequestUsageCarbonEmissionsDetails.
        Specifies the type of emission, such as MARKET_BASED or LOCATION_BASED.


        :param emission_type: The emission_type of this RequestUsageCarbonEmissionsDetails.
        :type: str
        """
        allowed_values = ["MARKET_BASED", "LOCATION_BASED"]
        if not value_allowed_none_or_none_sentinel(emission_type, allowed_values):
            emission_type = 'UNKNOWN_ENUM_VALUE'
        self._emission_type = emission_type

    @property
    def granularity(self):
        """
        Gets the granularity of this RequestUsageCarbonEmissionsDetails.
        The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.

        Allowed values for this property are: "DAILY", "MONTHLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The granularity of this RequestUsageCarbonEmissionsDetails.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity):
        """
        Sets the granularity of this RequestUsageCarbonEmissionsDetails.
        The carbon emission granularity. DAILY - Daily data aggregation. MONTHLY - Monthly data aggregation.


        :param granularity: The granularity of this RequestUsageCarbonEmissionsDetails.
        :type: str
        """
        allowed_values = ["DAILY", "MONTHLY"]
        if not value_allowed_none_or_none_sentinel(granularity, allowed_values):
            granularity = 'UNKNOWN_ENUM_VALUE'
        self._granularity = granularity

    @property
    def is_aggregate_by_time(self):
        """
        Gets the is_aggregate_by_time of this RequestUsageCarbonEmissionsDetails.
        Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.


        :return: The is_aggregate_by_time of this RequestUsageCarbonEmissionsDetails.
        :rtype: bool
        """
        return self._is_aggregate_by_time

    @is_aggregate_by_time.setter
    def is_aggregate_by_time(self, is_aggregate_by_time):
        """
        Sets the is_aggregate_by_time of this RequestUsageCarbonEmissionsDetails.
        Specifies whether aggregated by time. If isAggregateByTime is true, all carbon emissions usage over the query time period are summed.


        :param is_aggregate_by_time: The is_aggregate_by_time of this RequestUsageCarbonEmissionsDetails.
        :type: bool
        """
        self._is_aggregate_by_time = is_aggregate_by_time

    @property
    def group_by(self):
        """
        Gets the group_by of this RequestUsageCarbonEmissionsDetails.
        Aggregate the result by.
        For example:
          `[\"tagNamespace\", \"tagKey\", \"tagValue\", \"service\", \"skuName\", \"skuPartNumber\", \"unit\",
            \"compartmentName\", \"compartmentPath\", \"compartmentId\", \"platform\", \"region\", \"logicalAd\",
            \"resourceId\", \"resourceName\", \"tenantId\", \"tenantName\", \"subscriptionId\"]`


        :return: The group_by of this RequestUsageCarbonEmissionsDetails.
        :rtype: list[str]
        """
        return self._group_by

    @group_by.setter
    def group_by(self, group_by):
        """
        Sets the group_by of this RequestUsageCarbonEmissionsDetails.
        Aggregate the result by.
        For example:
          `[\"tagNamespace\", \"tagKey\", \"tagValue\", \"service\", \"skuName\", \"skuPartNumber\", \"unit\",
            \"compartmentName\", \"compartmentPath\", \"compartmentId\", \"platform\", \"region\", \"logicalAd\",
            \"resourceId\", \"resourceName\", \"tenantId\", \"tenantName\", \"subscriptionId\"]`


        :param group_by: The group_by of this RequestUsageCarbonEmissionsDetails.
        :type: list[str]
        """
        self._group_by = group_by

    @property
    def group_by_tag(self):
        """
        Gets the group_by_tag of this RequestUsageCarbonEmissionsDetails.
        GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list.
        For example:
          `[{\"namespace\":\"oracle\", \"key\":\"createdBy\"]`


        :return: The group_by_tag of this RequestUsageCarbonEmissionsDetails.
        :rtype: list[oci.usage_api.models.Tag]
        """
        return self._group_by_tag

    @group_by_tag.setter
    def group_by_tag(self, group_by_tag):
        """
        Sets the group_by_tag of this RequestUsageCarbonEmissionsDetails.
        GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list.
        For example:
          `[{\"namespace\":\"oracle\", \"key\":\"createdBy\"]`


        :param group_by_tag: The group_by_tag of this RequestUsageCarbonEmissionsDetails.
        :type: list[oci.usage_api.models.Tag]
        """
        self._group_by_tag = group_by_tag

    @property
    def compartment_depth(self):
        """
        Gets the compartment_depth of this RequestUsageCarbonEmissionsDetails.
        The compartment depth level.


        :return: The compartment_depth of this RequestUsageCarbonEmissionsDetails.
        :rtype: int
        """
        return self._compartment_depth

    @compartment_depth.setter
    def compartment_depth(self, compartment_depth):
        """
        Sets the compartment_depth of this RequestUsageCarbonEmissionsDetails.
        The compartment depth level.


        :param compartment_depth: The compartment_depth of this RequestUsageCarbonEmissionsDetails.
        :type: int
        """
        self._compartment_depth = compartment_depth

    @property
    def filter(self):
        """
        Gets the filter of this RequestUsageCarbonEmissionsDetails.

        :return: The filter of this RequestUsageCarbonEmissionsDetails.
        :rtype: oci.usage_api.models.Filter
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """
        Sets the filter of this RequestUsageCarbonEmissionsDetails.

        :param filter: The filter of this RequestUsageCarbonEmissionsDetails.
        :type: oci.usage_api.models.Filter
        """
        self._filter = filter

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
