# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210601

from .update_network_endpoint_details import UpdateNetworkEndpointDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdatePrivateEndpointDetails(UpdateNetworkEndpointDetails):
    """
    Private endpoint update configuration details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdatePrivateEndpointDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.visual_builder.models.UpdatePrivateEndpointDetails.network_endpoint_type` attribute
        of this class is ``PRIVATE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param network_endpoint_type:
            The value to assign to the network_endpoint_type property of this UpdatePrivateEndpointDetails.
            Allowed values for this property are: "PUBLIC", "PRIVATE"
        :type network_endpoint_type: str

        :param subnet_id:
            The value to assign to the subnet_id property of this UpdatePrivateEndpointDetails.
        :type subnet_id: str

        :param network_security_group_ids:
            The value to assign to the network_security_group_ids property of this UpdatePrivateEndpointDetails.
        :type network_security_group_ids: list[str]

        """
        self.swagger_types = {
            'network_endpoint_type': 'str',
            'subnet_id': 'str',
            'network_security_group_ids': 'list[str]'
        }
        self.attribute_map = {
            'network_endpoint_type': 'networkEndpointType',
            'subnet_id': 'subnetId',
            'network_security_group_ids': 'networkSecurityGroupIds'
        }
        self._network_endpoint_type = None
        self._subnet_id = None
        self._network_security_group_ids = None
        self._network_endpoint_type = 'PRIVATE'

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this UpdatePrivateEndpointDetails.
        The subnet OCID for the private endpoint. If provided then a new Private Endpoint will be created and a new Private Endpoint IP may be generated.


        :return: The subnet_id of this UpdatePrivateEndpointDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this UpdatePrivateEndpointDetails.
        The subnet OCID for the private endpoint. If provided then a new Private Endpoint will be created and a new Private Endpoint IP may be generated.


        :param subnet_id: The subnet_id of this UpdatePrivateEndpointDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def network_security_group_ids(self):
        """
        Gets the network_security_group_ids of this UpdatePrivateEndpointDetails.
        Network Security Group OCIDs for the Private Endpoint.


        :return: The network_security_group_ids of this UpdatePrivateEndpointDetails.
        :rtype: list[str]
        """
        return self._network_security_group_ids

    @network_security_group_ids.setter
    def network_security_group_ids(self, network_security_group_ids):
        """
        Sets the network_security_group_ids of this UpdatePrivateEndpointDetails.
        Network Security Group OCIDs for the Private Endpoint.


        :param network_security_group_ids: The network_security_group_ids of this UpdatePrivateEndpointDetails.
        :type: list[str]
        """
        self._network_security_group_ids = network_security_group_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
