# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostCisBenchmarkSettings(object):
    """
    CIS (Center for Internet Security) Benchmark scan settings for a host scan
    """

    #: A constant which can be used with the scan_level property of a HostCisBenchmarkSettings.
    #: This constant has a value of "NONE"
    SCAN_LEVEL_NONE = "NONE"

    #: A constant which can be used with the scan_level property of a HostCisBenchmarkSettings.
    #: This constant has a value of "LIGHT"
    SCAN_LEVEL_LIGHT = "LIGHT"

    #: A constant which can be used with the scan_level property of a HostCisBenchmarkSettings.
    #: This constant has a value of "MEDIUM"
    SCAN_LEVEL_MEDIUM = "MEDIUM"

    #: A constant which can be used with the scan_level property of a HostCisBenchmarkSettings.
    #: This constant has a value of "STRICT"
    SCAN_LEVEL_STRICT = "STRICT"

    def __init__(self, **kwargs):
        """
        Initializes a new HostCisBenchmarkSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param scan_level:
            The value to assign to the scan_level property of this HostCisBenchmarkSettings.
            Allowed values for this property are: "NONE", "LIGHT", "MEDIUM", "STRICT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type scan_level: str

        """
        self.swagger_types = {
            'scan_level': 'str'
        }
        self.attribute_map = {
            'scan_level': 'scanLevel'
        }
        self._scan_level = None

    @property
    def scan_level(self):
        """
        Gets the scan_level of this HostCisBenchmarkSettings.
        The level of strictness to apply for CIS Benchmarks. Use 'NONE' to disable CIS Benchmark checks entirely.

        Allowed values for this property are: "NONE", "LIGHT", "MEDIUM", "STRICT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The scan_level of this HostCisBenchmarkSettings.
        :rtype: str
        """
        return self._scan_level

    @scan_level.setter
    def scan_level(self, scan_level):
        """
        Sets the scan_level of this HostCisBenchmarkSettings.
        The level of strictness to apply for CIS Benchmarks. Use 'NONE' to disable CIS Benchmark checks entirely.


        :param scan_level: The scan_level of this HostCisBenchmarkSettings.
        :type: str
        """
        allowed_values = ["NONE", "LIGHT", "MEDIUM", "STRICT"]
        if not value_allowed_none_or_none_sentinel(scan_level, allowed_values):
            scan_level = 'UNKNOWN_ENUM_VALUE'
        self._scan_level = scan_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
