# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupToRestore(object):
    """
    Information of the backup to be used to restore a server in a domain.
    """

    #: A constant which can be used with the content_type property of a BackupToRestore.
    #: This constant has a value of "BINARY"
    CONTENT_TYPE_BINARY = "BINARY"

    def __init__(self, **kwargs):
        """
        Initializes a new BackupToRestore object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BackupToRestore.
        :type id: str

        :param content_type:
            The value to assign to the content_type property of this BackupToRestore.
            Allowed values for this property are: "BINARY"
        :type content_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'content_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'content_type': 'contentType'
        }
        self._id = None
        self._content_type = None

    @property
    def id(self):
        """
        Gets the id of this BackupToRestore.
        The unique identifier of the backup to be used to restore.

        **Note:** Not `OCIDs`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this BackupToRestore.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BackupToRestore.
        The unique identifier of the backup to be used to restore.

        **Note:** Not `OCIDs`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this BackupToRestore.
        :type: str
        """
        self._id = id

    @property
    def content_type(self):
        """
        Gets the content_type of this BackupToRestore.
        The type of content of the backup.

        Allowed values for this property are: "BINARY"


        :return: The content_type of this BackupToRestore.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this BackupToRestore.
        The type of content of the backup.


        :param content_type: The content_type of this BackupToRestore.
        :type: str
        """
        allowed_values = ["BINARY"]
        if not value_allowed_none_or_none_sentinel(content_type, allowed_values):
            raise ValueError(
                f"Invalid value for `content_type`, must be None or one of {allowed_values}"
            )
        self._content_type = content_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
