# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MiddlewareBackupPatch(object):
    """
    Information of a patch installed in the middleware binaries included in a backup.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MiddlewareBackupPatch object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MiddlewareBackupPatch.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this MiddlewareBackupPatch.
        :type display_name: str

        :param description:
            The value to assign to the description property of this MiddlewareBackupPatch.
        :type description: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description'
        }
        self._id = None
        self._display_name = None
        self._description = None

    @property
    def id(self):
        """
        Gets the id of this MiddlewareBackupPatch.
        The ID of the WebLogic patch.

        **Note:** Not an `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this MiddlewareBackupPatch.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MiddlewareBackupPatch.
        The ID of the WebLogic patch.

        **Note:** Not an `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this MiddlewareBackupPatch.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this MiddlewareBackupPatch.
        The display name of the WebLogic patch.


        :return: The display_name of this MiddlewareBackupPatch.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this MiddlewareBackupPatch.
        The display name of the WebLogic patch.


        :param display_name: The display_name of this MiddlewareBackupPatch.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this MiddlewareBackupPatch.
        The description of the WebLogic patch.


        :return: The description of this MiddlewareBackupPatch.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MiddlewareBackupPatch.
        The description of the WebLogic patch.


        :param description: The description of this MiddlewareBackupPatch.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
