# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServerToRestore(object):
    """
    The object containing server to restore and the backups to be used to restore.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ServerToRestore object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param server_id:
            The value to assign to the server_id property of this ServerToRestore.
        :type server_id: str

        :param backups:
            The value to assign to the backups property of this ServerToRestore.
        :type backups: list[oci.wlms.models.BackupToRestore]

        """
        self.swagger_types = {
            'server_id': 'str',
            'backups': 'list[BackupToRestore]'
        }
        self.attribute_map = {
            'server_id': 'serverId',
            'backups': 'backups'
        }
        self._server_id = None
        self._backups = None

    @property
    def server_id(self):
        """
        Gets the server_id of this ServerToRestore.
        The unique identifier of the server for which backup needs to be restored.

        **Note:** Not an `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The server_id of this ServerToRestore.
        :rtype: str
        """
        return self._server_id

    @server_id.setter
    def server_id(self, server_id):
        """
        Sets the server_id of this ServerToRestore.
        The unique identifier of the server for which backup needs to be restored.

        **Note:** Not an `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param server_id: The server_id of this ServerToRestore.
        :type: str
        """
        self._server_id = server_id

    @property
    def backups(self):
        """
        Gets the backups of this ServerToRestore.
        The list of backup unique identifiers to be used to restore.

        **Note:** Not `OCIDs`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The backups of this ServerToRestore.
        :rtype: list[oci.wlms.models.BackupToRestore]
        """
        return self._backups

    @backups.setter
    def backups(self, backups):
        """
        Sets the backups of this ServerToRestore.
        The list of backup unique identifiers to be used to restore.

        **Note:** Not `OCIDs`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param backups: The backups of this ServerToRestore.
        :type: list[oci.wlms.models.BackupToRestore]
        """
        self._backups = backups

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
