# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateWlsDomainConfigurationDetails(object):
    """
    The WebLogic domain configuration for update operation.
    """

    #: A constant which can be used with the admin_server_control_mode property of a UpdateWlsDomainConfigurationDetails.
    #: This constant has a value of "USE_NODE_MANAGER"
    ADMIN_SERVER_CONTROL_MODE_USE_NODE_MANAGER = "USE_NODE_MANAGER"

    #: A constant which can be used with the admin_server_control_mode property of a UpdateWlsDomainConfigurationDetails.
    #: This constant has a value of "USE_SCRIPTS"
    ADMIN_SERVER_CONTROL_MODE_USE_SCRIPTS = "USE_SCRIPTS"

    #: A constant which can be used with the managed_server_control_mode property of a UpdateWlsDomainConfigurationDetails.
    #: This constant has a value of "USE_NODE_MANAGER"
    MANAGED_SERVER_CONTROL_MODE_USE_NODE_MANAGER = "USE_NODE_MANAGER"

    #: A constant which can be used with the managed_server_control_mode property of a UpdateWlsDomainConfigurationDetails.
    #: This constant has a value of "USE_SCRIPTS"
    MANAGED_SERVER_CONTROL_MODE_USE_SCRIPTS = "USE_SCRIPTS"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateWlsDomainConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_patch_enabled:
            The value to assign to the is_patch_enabled property of this UpdateWlsDomainConfigurationDetails.
        :type is_patch_enabled: bool

        :param is_rollback_on_failure:
            The value to assign to the is_rollback_on_failure property of this UpdateWlsDomainConfigurationDetails.
        :type is_rollback_on_failure: bool

        :param servers_shutdown_timeout:
            The value to assign to the servers_shutdown_timeout property of this UpdateWlsDomainConfigurationDetails.
        :type servers_shutdown_timeout: int

        :param admin_server_control_mode:
            The value to assign to the admin_server_control_mode property of this UpdateWlsDomainConfigurationDetails.
            Allowed values for this property are: "USE_NODE_MANAGER", "USE_SCRIPTS"
        :type admin_server_control_mode: str

        :param managed_server_control_mode:
            The value to assign to the managed_server_control_mode property of this UpdateWlsDomainConfigurationDetails.
            Allowed values for this property are: "USE_NODE_MANAGER", "USE_SCRIPTS"
        :type managed_server_control_mode: str

        :param admin_server_start_script_path:
            The value to assign to the admin_server_start_script_path property of this UpdateWlsDomainConfigurationDetails.
        :type admin_server_start_script_path: str

        :param admin_server_stop_script_path:
            The value to assign to the admin_server_stop_script_path property of this UpdateWlsDomainConfigurationDetails.
        :type admin_server_stop_script_path: str

        :param managed_server_start_script_path:
            The value to assign to the managed_server_start_script_path property of this UpdateWlsDomainConfigurationDetails.
        :type managed_server_start_script_path: str

        :param managed_server_stop_script_path:
            The value to assign to the managed_server_stop_script_path property of this UpdateWlsDomainConfigurationDetails.
        :type managed_server_stop_script_path: str

        """
        self.swagger_types = {
            'is_patch_enabled': 'bool',
            'is_rollback_on_failure': 'bool',
            'servers_shutdown_timeout': 'int',
            'admin_server_control_mode': 'str',
            'managed_server_control_mode': 'str',
            'admin_server_start_script_path': 'str',
            'admin_server_stop_script_path': 'str',
            'managed_server_start_script_path': 'str',
            'managed_server_stop_script_path': 'str'
        }
        self.attribute_map = {
            'is_patch_enabled': 'isPatchEnabled',
            'is_rollback_on_failure': 'isRollbackOnFailure',
            'servers_shutdown_timeout': 'serversShutdownTimeout',
            'admin_server_control_mode': 'adminServerControlMode',
            'managed_server_control_mode': 'managedServerControlMode',
            'admin_server_start_script_path': 'adminServerStartScriptPath',
            'admin_server_stop_script_path': 'adminServerStopScriptPath',
            'managed_server_start_script_path': 'managedServerStartScriptPath',
            'managed_server_stop_script_path': 'managedServerStopScriptPath'
        }
        self._is_patch_enabled = None
        self._is_rollback_on_failure = None
        self._servers_shutdown_timeout = None
        self._admin_server_control_mode = None
        self._managed_server_control_mode = None
        self._admin_server_start_script_path = None
        self._admin_server_stop_script_path = None
        self._managed_server_start_script_path = None
        self._managed_server_stop_script_path = None

    @property
    def is_patch_enabled(self):
        """
        Gets the is_patch_enabled of this UpdateWlsDomainConfigurationDetails.
        Whether or not the WebLogic domain is enabled for patching.


        :return: The is_patch_enabled of this UpdateWlsDomainConfigurationDetails.
        :rtype: bool
        """
        return self._is_patch_enabled

    @is_patch_enabled.setter
    def is_patch_enabled(self, is_patch_enabled):
        """
        Sets the is_patch_enabled of this UpdateWlsDomainConfigurationDetails.
        Whether or not the WebLogic domain is enabled for patching.


        :param is_patch_enabled: The is_patch_enabled of this UpdateWlsDomainConfigurationDetails.
        :type: bool
        """
        self._is_patch_enabled = is_patch_enabled

    @property
    def is_rollback_on_failure(self):
        """
        Gets the is_rollback_on_failure of this UpdateWlsDomainConfigurationDetails.
        Whether or not to rollback on failure during patching of WebLogic domain.


        :return: The is_rollback_on_failure of this UpdateWlsDomainConfigurationDetails.
        :rtype: bool
        """
        return self._is_rollback_on_failure

    @is_rollback_on_failure.setter
    def is_rollback_on_failure(self, is_rollback_on_failure):
        """
        Sets the is_rollback_on_failure of this UpdateWlsDomainConfigurationDetails.
        Whether or not to rollback on failure during patching of WebLogic domain.


        :param is_rollback_on_failure: The is_rollback_on_failure of this UpdateWlsDomainConfigurationDetails.
        :type: bool
        """
        self._is_rollback_on_failure = is_rollback_on_failure

    @property
    def servers_shutdown_timeout(self):
        """
        Gets the servers_shutdown_timeout of this UpdateWlsDomainConfigurationDetails.
        Servers shutdown timeout in seconds. If set to 0 seconds, it means there is no timeout.


        :return: The servers_shutdown_timeout of this UpdateWlsDomainConfigurationDetails.
        :rtype: int
        """
        return self._servers_shutdown_timeout

    @servers_shutdown_timeout.setter
    def servers_shutdown_timeout(self, servers_shutdown_timeout):
        """
        Sets the servers_shutdown_timeout of this UpdateWlsDomainConfigurationDetails.
        Servers shutdown timeout in seconds. If set to 0 seconds, it means there is no timeout.


        :param servers_shutdown_timeout: The servers_shutdown_timeout of this UpdateWlsDomainConfigurationDetails.
        :type: int
        """
        self._servers_shutdown_timeout = servers_shutdown_timeout

    @property
    def admin_server_control_mode(self):
        """
        Gets the admin_server_control_mode of this UpdateWlsDomainConfigurationDetails.
        Whether to manage the admin server using Node Manager or scripts.

        Allowed values for this property are: "USE_NODE_MANAGER", "USE_SCRIPTS"


        :return: The admin_server_control_mode of this UpdateWlsDomainConfigurationDetails.
        :rtype: str
        """
        return self._admin_server_control_mode

    @admin_server_control_mode.setter
    def admin_server_control_mode(self, admin_server_control_mode):
        """
        Sets the admin_server_control_mode of this UpdateWlsDomainConfigurationDetails.
        Whether to manage the admin server using Node Manager or scripts.


        :param admin_server_control_mode: The admin_server_control_mode of this UpdateWlsDomainConfigurationDetails.
        :type: str
        """
        allowed_values = ["USE_NODE_MANAGER", "USE_SCRIPTS"]
        if not value_allowed_none_or_none_sentinel(admin_server_control_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `admin_server_control_mode`, must be None or one of {allowed_values}"
            )
        self._admin_server_control_mode = admin_server_control_mode

    @property
    def managed_server_control_mode(self):
        """
        Gets the managed_server_control_mode of this UpdateWlsDomainConfigurationDetails.
        Whether to manage the managed server using Node Manager or scripts.

        Allowed values for this property are: "USE_NODE_MANAGER", "USE_SCRIPTS"


        :return: The managed_server_control_mode of this UpdateWlsDomainConfigurationDetails.
        :rtype: str
        """
        return self._managed_server_control_mode

    @managed_server_control_mode.setter
    def managed_server_control_mode(self, managed_server_control_mode):
        """
        Sets the managed_server_control_mode of this UpdateWlsDomainConfigurationDetails.
        Whether to manage the managed server using Node Manager or scripts.


        :param managed_server_control_mode: The managed_server_control_mode of this UpdateWlsDomainConfigurationDetails.
        :type: str
        """
        allowed_values = ["USE_NODE_MANAGER", "USE_SCRIPTS"]
        if not value_allowed_none_or_none_sentinel(managed_server_control_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `managed_server_control_mode`, must be None or one of {allowed_values}"
            )
        self._managed_server_control_mode = managed_server_control_mode

    @property
    def admin_server_start_script_path(self):
        """
        Gets the admin_server_start_script_path of this UpdateWlsDomainConfigurationDetails.
        Path to admin server start script.


        :return: The admin_server_start_script_path of this UpdateWlsDomainConfigurationDetails.
        :rtype: str
        """
        return self._admin_server_start_script_path

    @admin_server_start_script_path.setter
    def admin_server_start_script_path(self, admin_server_start_script_path):
        """
        Sets the admin_server_start_script_path of this UpdateWlsDomainConfigurationDetails.
        Path to admin server start script.


        :param admin_server_start_script_path: The admin_server_start_script_path of this UpdateWlsDomainConfigurationDetails.
        :type: str
        """
        self._admin_server_start_script_path = admin_server_start_script_path

    @property
    def admin_server_stop_script_path(self):
        """
        Gets the admin_server_stop_script_path of this UpdateWlsDomainConfigurationDetails.
        Path to admin server stop script.


        :return: The admin_server_stop_script_path of this UpdateWlsDomainConfigurationDetails.
        :rtype: str
        """
        return self._admin_server_stop_script_path

    @admin_server_stop_script_path.setter
    def admin_server_stop_script_path(self, admin_server_stop_script_path):
        """
        Sets the admin_server_stop_script_path of this UpdateWlsDomainConfigurationDetails.
        Path to admin server stop script.


        :param admin_server_stop_script_path: The admin_server_stop_script_path of this UpdateWlsDomainConfigurationDetails.
        :type: str
        """
        self._admin_server_stop_script_path = admin_server_stop_script_path

    @property
    def managed_server_start_script_path(self):
        """
        Gets the managed_server_start_script_path of this UpdateWlsDomainConfigurationDetails.
        Path to managed server start script.


        :return: The managed_server_start_script_path of this UpdateWlsDomainConfigurationDetails.
        :rtype: str
        """
        return self._managed_server_start_script_path

    @managed_server_start_script_path.setter
    def managed_server_start_script_path(self, managed_server_start_script_path):
        """
        Sets the managed_server_start_script_path of this UpdateWlsDomainConfigurationDetails.
        Path to managed server start script.


        :param managed_server_start_script_path: The managed_server_start_script_path of this UpdateWlsDomainConfigurationDetails.
        :type: str
        """
        self._managed_server_start_script_path = managed_server_start_script_path

    @property
    def managed_server_stop_script_path(self):
        """
        Gets the managed_server_stop_script_path of this UpdateWlsDomainConfigurationDetails.
        Path to managed server stop script.


        :return: The managed_server_stop_script_path of this UpdateWlsDomainConfigurationDetails.
        :rtype: str
        """
        return self._managed_server_stop_script_path

    @managed_server_stop_script_path.setter
    def managed_server_stop_script_path(self, managed_server_stop_script_path):
        """
        Sets the managed_server_stop_script_path of this UpdateWlsDomainConfigurationDetails.
        Path to managed server stop script.


        :param managed_server_stop_script_path: The managed_server_stop_script_path of this UpdateWlsDomainConfigurationDetails.
        :type: str
        """
        self._managed_server_stop_script_path = managed_server_stop_script_path

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
