# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WlsDomainCredentialSummary(object):
    """
    The WebLogic domain credentials summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new WlsDomainCredentialSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this WlsDomainCredentialSummary.
        :type type: str

        :param strategy:
            The value to assign to the strategy property of this WlsDomainCredentialSummary.
        :type strategy: str

        """
        self.swagger_types = {
            'type': 'str',
            'strategy': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'strategy': 'strategy'
        }
        self._type = None
        self._strategy = None

    @property
    def type(self):
        """
        Gets the type of this WlsDomainCredentialSummary.
        The type of credential.


        :return: The type of this WlsDomainCredentialSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this WlsDomainCredentialSummary.
        The type of credential.


        :param type: The type of this WlsDomainCredentialSummary.
        :type: str
        """
        self._type = type

    @property
    def strategy(self):
        """
        Gets the strategy of this WlsDomainCredentialSummary.
        The strategy for passing new WebLogic credential.


        :return: The strategy of this WlsDomainCredentialSummary.
        :rtype: str
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """
        Sets the strategy of this WlsDomainCredentialSummary.
        The strategy for passing new WebLogic credential.


        :param strategy: The strategy of this WlsDomainCredentialSummary.
        :type: str
        """
        self._strategy = strategy

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
