# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApplicationDependencyRecommendationSummary(object):
    """
    An application dependency with the recommended version that does not contain any CVE.
    Each application dependency has a property specifying multiple node identifiers on which which this current node depends.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApplicationDependencyRecommendationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param gav:
            The value to assign to the gav property of this ApplicationDependencyRecommendationSummary.
        :type gav: str

        :param purl:
            The value to assign to the purl property of this ApplicationDependencyRecommendationSummary.
        :type purl: str

        :param node_id:
            The value to assign to the node_id property of this ApplicationDependencyRecommendationSummary.
        :type node_id: str

        :param application_dependency_node_ids:
            The value to assign to the application_dependency_node_ids property of this ApplicationDependencyRecommendationSummary.
        :type application_dependency_node_ids: list[str]

        :param recommended_gav:
            The value to assign to the recommended_gav property of this ApplicationDependencyRecommendationSummary.
        :type recommended_gav: str

        :param recommended_purl:
            The value to assign to the recommended_purl property of this ApplicationDependencyRecommendationSummary.
        :type recommended_purl: str

        """
        self.swagger_types = {
            'gav': 'str',
            'purl': 'str',
            'node_id': 'str',
            'application_dependency_node_ids': 'list[str]',
            'recommended_gav': 'str',
            'recommended_purl': 'str'
        }
        self.attribute_map = {
            'gav': 'gav',
            'purl': 'purl',
            'node_id': 'nodeId',
            'application_dependency_node_ids': 'applicationDependencyNodeIds',
            'recommended_gav': 'recommendedGav',
            'recommended_purl': 'recommendedPurl'
        }
        self._gav = None
        self._purl = None
        self._node_id = None
        self._application_dependency_node_ids = None
        self._recommended_gav = None
        self._recommended_purl = None

    @property
    def gav(self):
        """
        **[Required]** Gets the gav of this ApplicationDependencyRecommendationSummary.
        Unique Group Artifact Version (GAV) identifier in the format _Group:Artifact:Version_, e.g. org.graalvm.nativeimage:svm:21.1.0.


        :return: The gav of this ApplicationDependencyRecommendationSummary.
        :rtype: str
        """
        return self._gav

    @gav.setter
    def gav(self, gav):
        """
        Sets the gav of this ApplicationDependencyRecommendationSummary.
        Unique Group Artifact Version (GAV) identifier in the format _Group:Artifact:Version_, e.g. org.graalvm.nativeimage:svm:21.1.0.


        :param gav: The gav of this ApplicationDependencyRecommendationSummary.
        :type: str
        """
        self._gav = gav

    @property
    def purl(self):
        """
        Gets the purl of this ApplicationDependencyRecommendationSummary.
        Package URL identifier, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0


        :return: The purl of this ApplicationDependencyRecommendationSummary.
        :rtype: str
        """
        return self._purl

    @purl.setter
    def purl(self, purl):
        """
        Sets the purl of this ApplicationDependencyRecommendationSummary.
        Package URL identifier, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0


        :param purl: The purl of this ApplicationDependencyRecommendationSummary.
        :type: str
        """
        self._purl = purl

    @property
    def node_id(self):
        """
        **[Required]** Gets the node_id of this ApplicationDependencyRecommendationSummary.
        Unique node identifier of an application dependency with an associated Recommendation, e.g. nodeId1.


        :return: The node_id of this ApplicationDependencyRecommendationSummary.
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id):
        """
        Sets the node_id of this ApplicationDependencyRecommendationSummary.
        Unique node identifier of an application dependency with an associated Recommendation, e.g. nodeId1.


        :param node_id: The node_id of this ApplicationDependencyRecommendationSummary.
        :type: str
        """
        self._node_id = node_id

    @property
    def application_dependency_node_ids(self):
        """
        **[Required]** Gets the application_dependency_node_ids of this ApplicationDependencyRecommendationSummary.
        List of (application dependencies) node identifiers from which this node depends.


        :return: The application_dependency_node_ids of this ApplicationDependencyRecommendationSummary.
        :rtype: list[str]
        """
        return self._application_dependency_node_ids

    @application_dependency_node_ids.setter
    def application_dependency_node_ids(self, application_dependency_node_ids):
        """
        Sets the application_dependency_node_ids of this ApplicationDependencyRecommendationSummary.
        List of (application dependencies) node identifiers from which this node depends.


        :param application_dependency_node_ids: The application_dependency_node_ids of this ApplicationDependencyRecommendationSummary.
        :type: list[str]
        """
        self._application_dependency_node_ids = application_dependency_node_ids

    @property
    def recommended_gav(self):
        """
        Gets the recommended_gav of this ApplicationDependencyRecommendationSummary.
        Recommended application dependency in \"group:artifact:version\" (GAV) format, e.g. org.graalvm.nativeimage:svm:21.2.0.


        :return: The recommended_gav of this ApplicationDependencyRecommendationSummary.
        :rtype: str
        """
        return self._recommended_gav

    @recommended_gav.setter
    def recommended_gav(self, recommended_gav):
        """
        Sets the recommended_gav of this ApplicationDependencyRecommendationSummary.
        Recommended application dependency in \"group:artifact:version\" (GAV) format, e.g. org.graalvm.nativeimage:svm:21.2.0.


        :param recommended_gav: The recommended_gav of this ApplicationDependencyRecommendationSummary.
        :type: str
        """
        self._recommended_gav = recommended_gav

    @property
    def recommended_purl(self):
        """
        Gets the recommended_purl of this ApplicationDependencyRecommendationSummary.
        Recommended application dependency in purl format, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.2.0


        :return: The recommended_purl of this ApplicationDependencyRecommendationSummary.
        :rtype: str
        """
        return self._recommended_purl

    @recommended_purl.setter
    def recommended_purl(self, recommended_purl):
        """
        Sets the recommended_purl of this ApplicationDependencyRecommendationSummary.
        Recommended application dependency in purl format, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.2.0


        :param recommended_purl: The recommended_purl of this ApplicationDependencyRecommendationSummary.
        :type: str
        """
        self._recommended_purl = recommended_purl

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
