# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TranscriptionSettings(object):
    """
    Processes to perform on the generated transcription.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TranscriptionSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param diarization:
            The value to assign to the diarization property of this TranscriptionSettings.
        :type diarization: oci.ai_speech.models.Diarization

        :param additional_settings:
            The value to assign to the additional_settings property of this TranscriptionSettings.
        :type additional_settings: dict(str, str)

        """
        self.swagger_types = {
            'diarization': 'Diarization',
            'additional_settings': 'dict(str, str)'
        }
        self.attribute_map = {
            'diarization': 'diarization',
            'additional_settings': 'additionalSettings'
        }
        self._diarization = None
        self._additional_settings = None

    @property
    def diarization(self):
        """
        Gets the diarization of this TranscriptionSettings.

        :return: The diarization of this TranscriptionSettings.
        :rtype: oci.ai_speech.models.Diarization
        """
        return self._diarization

    @diarization.setter
    def diarization(self, diarization):
        """
        Sets the diarization of this TranscriptionSettings.

        :param diarization: The diarization of this TranscriptionSettings.
        :type: oci.ai_speech.models.Diarization
        """
        self._diarization = diarization

    @property
    def additional_settings(self):
        """
        Gets the additional_settings of this TranscriptionSettings.
        Simple key-value pair for setting model specific properties. For more details, refer the documentation.


        :return: The additional_settings of this TranscriptionSettings.
        :rtype: dict(str, str)
        """
        return self._additional_settings

    @additional_settings.setter
    def additional_settings(self, additional_settings):
        """
        Sets the additional_settings of this TranscriptionSettings.
        Simple key-value pair for setting model specific properties. For more details, refer the documentation.


        :param additional_settings: The additional_settings of this TranscriptionSettings.
        :type: dict(str, str)
        """
        self._additional_settings = additional_settings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
