# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoText(object):
    """
    Detected text in a video.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoText object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param text:
            The value to assign to the text property of this VideoText.
        :type text: str

        :param segments:
            The value to assign to the segments property of this VideoText.
        :type segments: list[oci.ai_vision.models.VideoTextSegment]

        """
        self.swagger_types = {
            'text': 'str',
            'segments': 'list[VideoTextSegment]'
        }
        self.attribute_map = {
            'text': 'text',
            'segments': 'segments'
        }
        self._text = None
        self._segments = None

    @property
    def text(self):
        """
        **[Required]** Gets the text of this VideoText.
        Detected text.


        :return: The text of this VideoText.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this VideoText.
        Detected text.


        :param text: The text of this VideoText.
        :type: str
        """
        self._text = text

    @property
    def segments(self):
        """
        **[Required]** Gets the segments of this VideoText.
        Text segments in a video.


        :return: The segments of this VideoText.
        :rtype: list[oci.ai_vision.models.VideoTextSegment]
        """
        return self._segments

    @segments.setter
    def segments(self, segments):
        """
        Sets the segments of this VideoText.
        Text segments in a video.


        :param segments: The segments of this VideoText.
        :type: list[oci.ai_vision.models.VideoTextSegment]
        """
        self._segments = segments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
