# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240829


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Uris(object):
    """
    Service URIs pertaining to the instance
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Uris object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param management_portal_uri:
            The value to assign to the management_portal_uri property of this Uris.
        :type management_portal_uri: str

        :param developers_portal_uri:
            The value to assign to the developers_portal_uri property of this Uris.
        :type developers_portal_uri: str

        """
        self.swagger_types = {
            'management_portal_uri': 'str',
            'developers_portal_uri': 'str'
        }
        self.attribute_map = {
            'management_portal_uri': 'managementPortalUri',
            'developers_portal_uri': 'developersPortalUri'
        }
        self._management_portal_uri = None
        self._developers_portal_uri = None

    @property
    def management_portal_uri(self):
        """
        **[Required]** Gets the management_portal_uri of this Uris.
        Management Portal URI of the instance (/apiplatform)


        :return: The management_portal_uri of this Uris.
        :rtype: str
        """
        return self._management_portal_uri

    @management_portal_uri.setter
    def management_portal_uri(self, management_portal_uri):
        """
        Sets the management_portal_uri of this Uris.
        Management Portal URI of the instance (/apiplatform)


        :param management_portal_uri: The management_portal_uri of this Uris.
        :type: str
        """
        self._management_portal_uri = management_portal_uri

    @property
    def developers_portal_uri(self):
        """
        **[Required]** Gets the developers_portal_uri of this Uris.
        Developer's Portal URI of the instance (/developers)


        :return: The developers_portal_uri of this Uris.
        :rtype: str
        """
        return self._developers_portal_uri

    @developers_portal_uri.setter
    def developers_portal_uri(self, developers_portal_uri):
        """
        Sets the developers_portal_uri of this Uris.
        Developer's Portal URI of the instance (/developers)


        :param developers_portal_uri: The developers_portal_uri of this Uris.
        :type: str
        """
        self._developers_portal_uri = developers_portal_uri

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
