# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePrivilegedApiRequestDetails(object):
    """
    An Oracle operator raises privilegedApi request when they need access to any infrastructure resource governed by PrivilegedApi Access Control.
    The privilegedApi request identifies the target resource and the set of operator actions. Access request handling depends upon the Operator Control
    that governs the target resource, and the set of operator actions listed for approval in the access request. If all of the operator actions
    listed in the privilegedApi request are in the pre-approved list in the PrivilegedApi Control that governs the target resource, then the privilegedApi request is
    automatically approved. If not, then the privilegedApi request requires explicit approval from the approver group specified by the PrivilegedApi Control governing the target resource.

    You can approve or reject an privilegedApi request. You can also revoke the approval of an already approved privilegedApi request. While creating an access request,
    the operator specifies the duration of access. You have the option to approve the entire duration or reduce or even increase the time duration.
    An operator can also request for an extension. The approval for such an extension is processed the same way the original privilegedApi request was processed.
    """

    #: A constant which can be used with the severity property of a CreatePrivilegedApiRequestDetails.
    #: This constant has a value of "SEV_1"
    SEVERITY_SEV_1 = "SEV_1"

    #: A constant which can be used with the severity property of a CreatePrivilegedApiRequestDetails.
    #: This constant has a value of "SEV_2"
    SEVERITY_SEV_2 = "SEV_2"

    #: A constant which can be used with the severity property of a CreatePrivilegedApiRequestDetails.
    #: This constant has a value of "SEV_3"
    SEVERITY_SEV_3 = "SEV_3"

    #: A constant which can be used with the severity property of a CreatePrivilegedApiRequestDetails.
    #: This constant has a value of "SEV_4"
    SEVERITY_SEV_4 = "SEV_4"

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePrivilegedApiRequestDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reason_summary:
            The value to assign to the reason_summary property of this CreatePrivilegedApiRequestDetails.
        :type reason_summary: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreatePrivilegedApiRequestDetails.
        :type compartment_id: str

        :param resource_id:
            The value to assign to the resource_id property of this CreatePrivilegedApiRequestDetails.
        :type resource_id: str

        :param sub_resource_name_list:
            The value to assign to the sub_resource_name_list property of this CreatePrivilegedApiRequestDetails.
        :type sub_resource_name_list: list[str]

        :param privileged_operation_list:
            The value to assign to the privileged_operation_list property of this CreatePrivilegedApiRequestDetails.
        :type privileged_operation_list: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]

        :param notification_topic_id:
            The value to assign to the notification_topic_id property of this CreatePrivilegedApiRequestDetails.
        :type notification_topic_id: str

        :param reason_detail:
            The value to assign to the reason_detail property of this CreatePrivilegedApiRequestDetails.
        :type reason_detail: str

        :param severity:
            The value to assign to the severity property of this CreatePrivilegedApiRequestDetails.
            Allowed values for this property are: "SEV_1", "SEV_2", "SEV_3", "SEV_4"
        :type severity: str

        :param duration_in_hrs:
            The value to assign to the duration_in_hrs property of this CreatePrivilegedApiRequestDetails.
        :type duration_in_hrs: int

        :param ticket_numbers:
            The value to assign to the ticket_numbers property of this CreatePrivilegedApiRequestDetails.
        :type ticket_numbers: list[str]

        :param time_requested_for_future_access:
            The value to assign to the time_requested_for_future_access property of this CreatePrivilegedApiRequestDetails.
        :type time_requested_for_future_access: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreatePrivilegedApiRequestDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreatePrivilegedApiRequestDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'reason_summary': 'str',
            'compartment_id': 'str',
            'resource_id': 'str',
            'sub_resource_name_list': 'list[str]',
            'privileged_operation_list': 'list[PrivilegedApiRequestOperationDetails]',
            'notification_topic_id': 'str',
            'reason_detail': 'str',
            'severity': 'str',
            'duration_in_hrs': 'int',
            'ticket_numbers': 'list[str]',
            'time_requested_for_future_access': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'reason_summary': 'reasonSummary',
            'compartment_id': 'compartmentId',
            'resource_id': 'resourceId',
            'sub_resource_name_list': 'subResourceNameList',
            'privileged_operation_list': 'privilegedOperationList',
            'notification_topic_id': 'notificationTopicId',
            'reason_detail': 'reasonDetail',
            'severity': 'severity',
            'duration_in_hrs': 'durationInHrs',
            'ticket_numbers': 'ticketNumbers',
            'time_requested_for_future_access': 'timeRequestedForFutureAccess',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._reason_summary = None
        self._compartment_id = None
        self._resource_id = None
        self._sub_resource_name_list = None
        self._privileged_operation_list = None
        self._notification_topic_id = None
        self._reason_detail = None
        self._severity = None
        self._duration_in_hrs = None
        self._ticket_numbers = None
        self._time_requested_for_future_access = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def reason_summary(self):
        """
        **[Required]** Gets the reason_summary of this CreatePrivilegedApiRequestDetails.
        Summary comment by the operator creating the access request.


        :return: The reason_summary of this CreatePrivilegedApiRequestDetails.
        :rtype: str
        """
        return self._reason_summary

    @reason_summary.setter
    def reason_summary(self, reason_summary):
        """
        Sets the reason_summary of this CreatePrivilegedApiRequestDetails.
        Summary comment by the operator creating the access request.


        :param reason_summary: The reason_summary of this CreatePrivilegedApiRequestDetails.
        :type: str
        """
        self._reason_summary = reason_summary

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CreatePrivilegedApiRequestDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreatePrivilegedApiRequestDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreatePrivilegedApiRequestDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreatePrivilegedApiRequestDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this CreatePrivilegedApiRequestDetails.
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.


        :return: The resource_id of this CreatePrivilegedApiRequestDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this CreatePrivilegedApiRequestDetails.
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.


        :param resource_id: The resource_id of this CreatePrivilegedApiRequestDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def sub_resource_name_list(self):
        """
        Gets the sub_resource_name_list of this CreatePrivilegedApiRequestDetails.
        The subresource names requested for approval.


        :return: The sub_resource_name_list of this CreatePrivilegedApiRequestDetails.
        :rtype: list[str]
        """
        return self._sub_resource_name_list

    @sub_resource_name_list.setter
    def sub_resource_name_list(self, sub_resource_name_list):
        """
        Sets the sub_resource_name_list of this CreatePrivilegedApiRequestDetails.
        The subresource names requested for approval.


        :param sub_resource_name_list: The sub_resource_name_list of this CreatePrivilegedApiRequestDetails.
        :type: list[str]
        """
        self._sub_resource_name_list = sub_resource_name_list

    @property
    def privileged_operation_list(self):
        """
        **[Required]** Gets the privileged_operation_list of this CreatePrivilegedApiRequestDetails.
        List of api names, attributes for which approval is sought by the user.


        :return: The privileged_operation_list of this CreatePrivilegedApiRequestDetails.
        :rtype: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]
        """
        return self._privileged_operation_list

    @privileged_operation_list.setter
    def privileged_operation_list(self, privileged_operation_list):
        """
        Sets the privileged_operation_list of this CreatePrivilegedApiRequestDetails.
        List of api names, attributes for which approval is sought by the user.


        :param privileged_operation_list: The privileged_operation_list of this CreatePrivilegedApiRequestDetails.
        :type: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]
        """
        self._privileged_operation_list = privileged_operation_list

    @property
    def notification_topic_id(self):
        """
        Gets the notification_topic_id of this CreatePrivilegedApiRequestDetails.
        The OCID of the OCI Notification topic to publish messages related to this Privileged Api Request.


        :return: The notification_topic_id of this CreatePrivilegedApiRequestDetails.
        :rtype: str
        """
        return self._notification_topic_id

    @notification_topic_id.setter
    def notification_topic_id(self, notification_topic_id):
        """
        Sets the notification_topic_id of this CreatePrivilegedApiRequestDetails.
        The OCID of the OCI Notification topic to publish messages related to this Privileged Api Request.


        :param notification_topic_id: The notification_topic_id of this CreatePrivilegedApiRequestDetails.
        :type: str
        """
        self._notification_topic_id = notification_topic_id

    @property
    def reason_detail(self):
        """
        Gets the reason_detail of this CreatePrivilegedApiRequestDetails.
        Reason in detail for which the operator is requesting access on the target resource.


        :return: The reason_detail of this CreatePrivilegedApiRequestDetails.
        :rtype: str
        """
        return self._reason_detail

    @reason_detail.setter
    def reason_detail(self, reason_detail):
        """
        Sets the reason_detail of this CreatePrivilegedApiRequestDetails.
        Reason in detail for which the operator is requesting access on the target resource.


        :param reason_detail: The reason_detail of this CreatePrivilegedApiRequestDetails.
        :type: str
        """
        self._reason_detail = reason_detail

    @property
    def severity(self):
        """
        Gets the severity of this CreatePrivilegedApiRequestDetails.
        Priority assigned to the access request by the operator

        Allowed values for this property are: "SEV_1", "SEV_2", "SEV_3", "SEV_4"


        :return: The severity of this CreatePrivilegedApiRequestDetails.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this CreatePrivilegedApiRequestDetails.
        Priority assigned to the access request by the operator


        :param severity: The severity of this CreatePrivilegedApiRequestDetails.
        :type: str
        """
        allowed_values = ["SEV_1", "SEV_2", "SEV_3", "SEV_4"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            raise ValueError(
                f"Invalid value for `severity`, must be None or one of {allowed_values}"
            )
        self._severity = severity

    @property
    def duration_in_hrs(self):
        """
        Gets the duration_in_hrs of this CreatePrivilegedApiRequestDetails.
        Duration in hours for which access is sought on the target resource.


        :return: The duration_in_hrs of this CreatePrivilegedApiRequestDetails.
        :rtype: int
        """
        return self._duration_in_hrs

    @duration_in_hrs.setter
    def duration_in_hrs(self, duration_in_hrs):
        """
        Sets the duration_in_hrs of this CreatePrivilegedApiRequestDetails.
        Duration in hours for which access is sought on the target resource.


        :param duration_in_hrs: The duration_in_hrs of this CreatePrivilegedApiRequestDetails.
        :type: int
        """
        self._duration_in_hrs = duration_in_hrs

    @property
    def ticket_numbers(self):
        """
        Gets the ticket_numbers of this CreatePrivilegedApiRequestDetails.
        A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.


        :return: The ticket_numbers of this CreatePrivilegedApiRequestDetails.
        :rtype: list[str]
        """
        return self._ticket_numbers

    @ticket_numbers.setter
    def ticket_numbers(self, ticket_numbers):
        """
        Sets the ticket_numbers of this CreatePrivilegedApiRequestDetails.
        A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.


        :param ticket_numbers: The ticket_numbers of this CreatePrivilegedApiRequestDetails.
        :type: list[str]
        """
        self._ticket_numbers = ticket_numbers

    @property
    def time_requested_for_future_access(self):
        """
        Gets the time_requested_for_future_access of this CreatePrivilegedApiRequestDetails.
        Time in future when the user for the privilegedApi request needs to be created in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_requested_for_future_access of this CreatePrivilegedApiRequestDetails.
        :rtype: datetime
        """
        return self._time_requested_for_future_access

    @time_requested_for_future_access.setter
    def time_requested_for_future_access(self, time_requested_for_future_access):
        """
        Sets the time_requested_for_future_access of this CreatePrivilegedApiRequestDetails.
        Time in future when the user for the privilegedApi request needs to be created in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_requested_for_future_access: The time_requested_for_future_access of this CreatePrivilegedApiRequestDetails.
        :type: datetime
        """
        self._time_requested_for_future_access = time_requested_for_future_access

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreatePrivilegedApiRequestDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreatePrivilegedApiRequestDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreatePrivilegedApiRequestDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreatePrivilegedApiRequestDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreatePrivilegedApiRequestDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreatePrivilegedApiRequestDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreatePrivilegedApiRequestDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreatePrivilegedApiRequestDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
