# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivilegedApiRequest(object):
    """
    An Oracle operator raises privilegedApi request when they need access to any infrastructure resource governed by PrivilegedApi Access Control.
    The privilegedApi request identifies the target resource and the set of operator actions. Access request handling depends upon the Operator Control
    that governs the target resource, and the set of operator actions listed for approval in the access request. If all of the operator actions
    listed in the privilegedApi request are in the pre-approved list in the PrivilegedApi Control that governs the target resource, then the privilegedApi request is
    automatically approved. If not, then the privilegedApi request requires explicit approval from the approver group specified by the PrivilegedApi Control governing the target resource.

    You can approve or reject an privilegedApi request. You can also revoke the approval of an already approved privilegedApi request. While creating an access request,
    the operator specifies the duration of access. You have the option to approve the entire duration or reduce or even increase the time duration.
    An operator can also request for an extension. The approval for such an extension is processed the same way the original privilegedApi request was processed.
    """

    #: A constant which can be used with the severity property of a PrivilegedApiRequest.
    #: This constant has a value of "SEV_1"
    SEVERITY_SEV_1 = "SEV_1"

    #: A constant which can be used with the severity property of a PrivilegedApiRequest.
    #: This constant has a value of "SEV_2"
    SEVERITY_SEV_2 = "SEV_2"

    #: A constant which can be used with the severity property of a PrivilegedApiRequest.
    #: This constant has a value of "SEV_3"
    SEVERITY_SEV_3 = "SEV_3"

    #: A constant which can be used with the severity property of a PrivilegedApiRequest.
    #: This constant has a value of "SEV_4"
    SEVERITY_SEV_4 = "SEV_4"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "CREATED"
    STATE_CREATED = "CREATED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "APPROVAL_WAITING"
    STATE_APPROVAL_WAITING = "APPROVAL_WAITING"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "APPROVED"
    STATE_APPROVED = "APPROVED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "APPROVED_FOR_FUTURE"
    STATE_APPROVED_FOR_FUTURE = "APPROVED_FOR_FUTURE"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "REJECTED"
    STATE_REJECTED = "REJECTED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "DEPLOYED"
    STATE_DEPLOYED = "DEPLOYED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "DEPLOY_FAILED"
    STATE_DEPLOY_FAILED = "DEPLOY_FAILED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "CLOSE_FAILED"
    STATE_CLOSE_FAILED = "CLOSE_FAILED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "REVOKE_FAILED"
    STATE_REVOKE_FAILED = "REVOKE_FAILED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "EXPIRY_FAILED"
    STATE_EXPIRY_FAILED = "EXPIRY_FAILED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "REVOKING"
    STATE_REVOKING = "REVOKING"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "REVOKED"
    STATE_REVOKED = "REVOKED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "CLOSING"
    STATE_CLOSING = "CLOSING"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "CLOSED"
    STATE_CLOSED = "CLOSED"

    #: A constant which can be used with the state property of a PrivilegedApiRequest.
    #: This constant has a value of "EXPIRED"
    STATE_EXPIRED = "EXPIRED"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiRequest.
    #: This constant has a value of "ACCEPTED"
    LIFECYCLE_STATE_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiRequest.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiRequest.
    #: This constant has a value of "WAITING"
    LIFECYCLE_STATE_WAITING = "WAITING"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiRequest.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiRequest.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiRequest.
    #: This constant has a value of "CANCELING"
    LIFECYCLE_STATE_CANCELING = "CANCELING"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiRequest.
    #: This constant has a value of "CANCELED"
    LIFECYCLE_STATE_CANCELED = "CANCELED"

    #: A constant which can be used with the lifecycle_state property of a PrivilegedApiRequest.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new PrivilegedApiRequest object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PrivilegedApiRequest.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this PrivilegedApiRequest.
        :type display_name: str

        :param request_id:
            The value to assign to the request_id property of this PrivilegedApiRequest.
        :type request_id: str

        :param reason_summary:
            The value to assign to the reason_summary property of this PrivilegedApiRequest.
        :type reason_summary: str

        :param notification_topic_id:
            The value to assign to the notification_topic_id property of this PrivilegedApiRequest.
        :type notification_topic_id: str

        :param requested_by:
            The value to assign to the requested_by property of this PrivilegedApiRequest.
        :type requested_by: list[str]

        :param resource_name:
            The value to assign to the resource_name property of this PrivilegedApiRequest.
        :type resource_name: str

        :param resource_id:
            The value to assign to the resource_id property of this PrivilegedApiRequest.
        :type resource_id: str

        :param sub_resource_name_list:
            The value to assign to the sub_resource_name_list property of this PrivilegedApiRequest.
        :type sub_resource_name_list: list[str]

        :param compartment_id:
            The value to assign to the compartment_id property of this PrivilegedApiRequest.
        :type compartment_id: str

        :param resource_type:
            The value to assign to the resource_type property of this PrivilegedApiRequest.
        :type resource_type: str

        :param entity_type:
            The value to assign to the entity_type property of this PrivilegedApiRequest.
        :type entity_type: str

        :param privileged_operation_list:
            The value to assign to the privileged_operation_list property of this PrivilegedApiRequest.
        :type privileged_operation_list: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]

        :param reason_detail:
            The value to assign to the reason_detail property of this PrivilegedApiRequest.
        :type reason_detail: str

        :param severity:
            The value to assign to the severity property of this PrivilegedApiRequest.
            Allowed values for this property are: "SEV_1", "SEV_2", "SEV_3", "SEV_4", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param duration_in_hrs:
            The value to assign to the duration_in_hrs property of this PrivilegedApiRequest.
        :type duration_in_hrs: int

        :param ticket_numbers:
            The value to assign to the ticket_numbers property of this PrivilegedApiRequest.
        :type ticket_numbers: list[str]

        :param state:
            The value to assign to the state property of this PrivilegedApiRequest.
            Allowed values for this property are: "CREATED", "APPROVAL_WAITING", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "CLOSING", "CLOSED", "EXPIRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param state_details:
            The value to assign to the state_details property of this PrivilegedApiRequest.
        :type state_details: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PrivilegedApiRequest.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this PrivilegedApiRequest.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this PrivilegedApiRequest.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this PrivilegedApiRequest.
        :type time_updated: datetime

        :param closure_comment:
            The value to assign to the closure_comment property of this PrivilegedApiRequest.
        :type closure_comment: str

        :param privileged_api_control_id:
            The value to assign to the privileged_api_control_id property of this PrivilegedApiRequest.
        :type privileged_api_control_id: str

        :param privileged_api_control_name:
            The value to assign to the privileged_api_control_name property of this PrivilegedApiRequest.
        :type privileged_api_control_name: str

        :param number_of_approvers_required:
            The value to assign to the number_of_approvers_required property of this PrivilegedApiRequest.
        :type number_of_approvers_required: int

        :param approver_details:
            The value to assign to the approver_details property of this PrivilegedApiRequest.
        :type approver_details: list[oci.apiaccesscontrol.models.ApproverDetail]

        :param time_requested_for_future_access:
            The value to assign to the time_requested_for_future_access property of this PrivilegedApiRequest.
        :type time_requested_for_future_access: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PrivilegedApiRequest.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this PrivilegedApiRequest.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this PrivilegedApiRequest.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'request_id': 'str',
            'reason_summary': 'str',
            'notification_topic_id': 'str',
            'requested_by': 'list[str]',
            'resource_name': 'str',
            'resource_id': 'str',
            'sub_resource_name_list': 'list[str]',
            'compartment_id': 'str',
            'resource_type': 'str',
            'entity_type': 'str',
            'privileged_operation_list': 'list[PrivilegedApiRequestOperationDetails]',
            'reason_detail': 'str',
            'severity': 'str',
            'duration_in_hrs': 'int',
            'ticket_numbers': 'list[str]',
            'state': 'str',
            'state_details': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'closure_comment': 'str',
            'privileged_api_control_id': 'str',
            'privileged_api_control_name': 'str',
            'number_of_approvers_required': 'int',
            'approver_details': 'list[ApproverDetail]',
            'time_requested_for_future_access': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'request_id': 'requestId',
            'reason_summary': 'reasonSummary',
            'notification_topic_id': 'notificationTopicId',
            'requested_by': 'requestedBy',
            'resource_name': 'resourceName',
            'resource_id': 'resourceId',
            'sub_resource_name_list': 'subResourceNameList',
            'compartment_id': 'compartmentId',
            'resource_type': 'resourceType',
            'entity_type': 'entityType',
            'privileged_operation_list': 'privilegedOperationList',
            'reason_detail': 'reasonDetail',
            'severity': 'severity',
            'duration_in_hrs': 'durationInHrs',
            'ticket_numbers': 'ticketNumbers',
            'state': 'state',
            'state_details': 'stateDetails',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'closure_comment': 'closureComment',
            'privileged_api_control_id': 'privilegedApiControlId',
            'privileged_api_control_name': 'privilegedApiControlName',
            'number_of_approvers_required': 'numberOfApproversRequired',
            'approver_details': 'approverDetails',
            'time_requested_for_future_access': 'timeRequestedForFutureAccess',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._request_id = None
        self._reason_summary = None
        self._notification_topic_id = None
        self._requested_by = None
        self._resource_name = None
        self._resource_id = None
        self._sub_resource_name_list = None
        self._compartment_id = None
        self._resource_type = None
        self._entity_type = None
        self._privileged_operation_list = None
        self._reason_detail = None
        self._severity = None
        self._duration_in_hrs = None
        self._ticket_numbers = None
        self._state = None
        self._state_details = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._closure_comment = None
        self._privileged_api_control_id = None
        self._privileged_api_control_name = None
        self._number_of_approvers_required = None
        self._approver_details = None
        self._time_requested_for_future_access = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PrivilegedApiRequest.
        The OCID of the privilegedApi request.


        :return: The id of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PrivilegedApiRequest.
        The OCID of the privilegedApi request.


        :param id: The id of this PrivilegedApiRequest.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this PrivilegedApiRequest.
        Name of the privilegedApi control. The name must be unique.


        :return: The display_name of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PrivilegedApiRequest.
        Name of the privilegedApi control. The name must be unique.


        :param display_name: The display_name of this PrivilegedApiRequest.
        :type: str
        """
        self._display_name = display_name

    @property
    def request_id(self):
        """
        Gets the request_id of this PrivilegedApiRequest.
        This is an automatic identifier generated by the system which is easier for human comprehension.


        :return: The request_id of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """
        Sets the request_id of this PrivilegedApiRequest.
        This is an automatic identifier generated by the system which is easier for human comprehension.


        :param request_id: The request_id of this PrivilegedApiRequest.
        :type: str
        """
        self._request_id = request_id

    @property
    def reason_summary(self):
        """
        **[Required]** Gets the reason_summary of this PrivilegedApiRequest.
        Summary comment by the operator creating the access request.


        :return: The reason_summary of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._reason_summary

    @reason_summary.setter
    def reason_summary(self, reason_summary):
        """
        Sets the reason_summary of this PrivilegedApiRequest.
        Summary comment by the operator creating the access request.


        :param reason_summary: The reason_summary of this PrivilegedApiRequest.
        :type: str
        """
        self._reason_summary = reason_summary

    @property
    def notification_topic_id(self):
        """
        Gets the notification_topic_id of this PrivilegedApiRequest.
        The OCID of the OCI Notification topic to publish messages related to this privileged api request.


        :return: The notification_topic_id of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._notification_topic_id

    @notification_topic_id.setter
    def notification_topic_id(self, notification_topic_id):
        """
        Sets the notification_topic_id of this PrivilegedApiRequest.
        The OCID of the OCI Notification topic to publish messages related to this privileged api request.


        :param notification_topic_id: The notification_topic_id of this PrivilegedApiRequest.
        :type: str
        """
        self._notification_topic_id = notification_topic_id

    @property
    def requested_by(self):
        """
        Gets the requested_by of this PrivilegedApiRequest.
        List of Users who has created this privilegedApiRequest.


        :return: The requested_by of this PrivilegedApiRequest.
        :rtype: list[str]
        """
        return self._requested_by

    @requested_by.setter
    def requested_by(self, requested_by):
        """
        Sets the requested_by of this PrivilegedApiRequest.
        List of Users who has created this privilegedApiRequest.


        :param requested_by: The requested_by of this PrivilegedApiRequest.
        :type: list[str]
        """
        self._requested_by = requested_by

    @property
    def resource_name(self):
        """
        Gets the resource_name of this PrivilegedApiRequest.
        resourceName for which the PrivilegedApiRequest is applicable


        :return: The resource_name of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this PrivilegedApiRequest.
        resourceName for which the PrivilegedApiRequest is applicable


        :param resource_name: The resource_name of this PrivilegedApiRequest.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this PrivilegedApiRequest.
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.


        :return: The resource_id of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this PrivilegedApiRequest.
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.


        :param resource_id: The resource_id of this PrivilegedApiRequest.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def sub_resource_name_list(self):
        """
        Gets the sub_resource_name_list of this PrivilegedApiRequest.
        The subresource names requested for approval.


        :return: The sub_resource_name_list of this PrivilegedApiRequest.
        :rtype: list[str]
        """
        return self._sub_resource_name_list

    @sub_resource_name_list.setter
    def sub_resource_name_list(self, sub_resource_name_list):
        """
        Sets the sub_resource_name_list of this PrivilegedApiRequest.
        The subresource names requested for approval.


        :param sub_resource_name_list: The sub_resource_name_list of this PrivilegedApiRequest.
        :type: list[str]
        """
        self._sub_resource_name_list = sub_resource_name_list

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this PrivilegedApiRequest.
        The OCID of the compartment that contains the access request.


        :return: The compartment_id of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PrivilegedApiRequest.
        The OCID of the compartment that contains the access request.


        :param compartment_id: The compartment_id of this PrivilegedApiRequest.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_type(self):
        """
        Gets the resource_type of this PrivilegedApiRequest.
        resourceType for which the AccessRequest is applicable


        :return: The resource_type of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this PrivilegedApiRequest.
        resourceType for which the AccessRequest is applicable


        :param resource_type: The resource_type of this PrivilegedApiRequest.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def entity_type(self):
        """
        Gets the entity_type of this PrivilegedApiRequest.
        entityType of resource for which the AccessRequest is applicable


        :return: The entity_type of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this PrivilegedApiRequest.
        entityType of resource for which the AccessRequest is applicable


        :param entity_type: The entity_type of this PrivilegedApiRequest.
        :type: str
        """
        self._entity_type = entity_type

    @property
    def privileged_operation_list(self):
        """
        Gets the privileged_operation_list of this PrivilegedApiRequest.
        List of api names, attributes for which approval is sought by the user.


        :return: The privileged_operation_list of this PrivilegedApiRequest.
        :rtype: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]
        """
        return self._privileged_operation_list

    @privileged_operation_list.setter
    def privileged_operation_list(self, privileged_operation_list):
        """
        Sets the privileged_operation_list of this PrivilegedApiRequest.
        List of api names, attributes for which approval is sought by the user.


        :param privileged_operation_list: The privileged_operation_list of this PrivilegedApiRequest.
        :type: list[oci.apiaccesscontrol.models.PrivilegedApiRequestOperationDetails]
        """
        self._privileged_operation_list = privileged_operation_list

    @property
    def reason_detail(self):
        """
        Gets the reason_detail of this PrivilegedApiRequest.
        Reason in Detail for which the operator is requesting access on the target resource.


        :return: The reason_detail of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._reason_detail

    @reason_detail.setter
    def reason_detail(self, reason_detail):
        """
        Sets the reason_detail of this PrivilegedApiRequest.
        Reason in Detail for which the operator is requesting access on the target resource.


        :param reason_detail: The reason_detail of this PrivilegedApiRequest.
        :type: str
        """
        self._reason_detail = reason_detail

    @property
    def severity(self):
        """
        Gets the severity of this PrivilegedApiRequest.
        Priority assigned to the access request by the operator

        Allowed values for this property are: "SEV_1", "SEV_2", "SEV_3", "SEV_4", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this PrivilegedApiRequest.
        Priority assigned to the access request by the operator


        :param severity: The severity of this PrivilegedApiRequest.
        :type: str
        """
        allowed_values = ["SEV_1", "SEV_2", "SEV_3", "SEV_4"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def duration_in_hrs(self):
        """
        Gets the duration_in_hrs of this PrivilegedApiRequest.
        Duration in hours for which access is sought on the target resource.


        :return: The duration_in_hrs of this PrivilegedApiRequest.
        :rtype: int
        """
        return self._duration_in_hrs

    @duration_in_hrs.setter
    def duration_in_hrs(self, duration_in_hrs):
        """
        Sets the duration_in_hrs of this PrivilegedApiRequest.
        Duration in hours for which access is sought on the target resource.


        :param duration_in_hrs: The duration_in_hrs of this PrivilegedApiRequest.
        :type: int
        """
        self._duration_in_hrs = duration_in_hrs

    @property
    def ticket_numbers(self):
        """
        Gets the ticket_numbers of this PrivilegedApiRequest.
        A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.


        :return: The ticket_numbers of this PrivilegedApiRequest.
        :rtype: list[str]
        """
        return self._ticket_numbers

    @ticket_numbers.setter
    def ticket_numbers(self, ticket_numbers):
        """
        Sets the ticket_numbers of this PrivilegedApiRequest.
        A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.


        :param ticket_numbers: The ticket_numbers of this PrivilegedApiRequest.
        :type: list[str]
        """
        self._ticket_numbers = ticket_numbers

    @property
    def state(self):
        """
        **[Required]** Gets the state of this PrivilegedApiRequest.
        The current state of the Access Request.

        Allowed values for this property are: "CREATED", "APPROVAL_WAITING", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "CLOSING", "CLOSED", "EXPIRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this PrivilegedApiRequest.
        The current state of the Access Request.


        :param state: The state of this PrivilegedApiRequest.
        :type: str
        """
        allowed_values = ["CREATED", "APPROVAL_WAITING", "APPROVED", "APPROVED_FOR_FUTURE", "REJECTED", "DEPLOYED", "DEPLOY_FAILED", "CLOSE_FAILED", "REVOKE_FAILED", "EXPIRY_FAILED", "REVOKING", "REVOKED", "CLOSING", "CLOSED", "EXPIRED"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def state_details(self):
        """
        Gets the state_details of this PrivilegedApiRequest.
        A message that describes the current state of the PrivilegedApiControl in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The state_details of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._state_details

    @state_details.setter
    def state_details(self, state_details):
        """
        Sets the state_details of this PrivilegedApiRequest.
        A message that describes the current state of the PrivilegedApiControl in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param state_details: The state_details of this PrivilegedApiRequest.
        :type: str
        """
        self._state_details = state_details

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this PrivilegedApiRequest.
        The current state of the PrivilegedApiRequest.

        Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PrivilegedApiRequest.
        The current state of the PrivilegedApiRequest.


        :param lifecycle_state: The lifecycle_state of this PrivilegedApiRequest.
        :type: str
        """
        allowed_values = ["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this PrivilegedApiRequest.
        more in detail about the lifeCycleState.


        :return: The lifecycle_details of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this PrivilegedApiRequest.
        more in detail about the lifeCycleState.


        :param lifecycle_details: The lifecycle_details of this PrivilegedApiRequest.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        Gets the time_created of this PrivilegedApiRequest.
        Time when the privilegedApi request was created in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this PrivilegedApiRequest.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PrivilegedApiRequest.
        Time when the privilegedApi request was created in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this PrivilegedApiRequest.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this PrivilegedApiRequest.
        Time when the privilegedApi request was last modified in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this PrivilegedApiRequest.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PrivilegedApiRequest.
        Time when the privilegedApi request was last modified in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this PrivilegedApiRequest.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def closure_comment(self):
        """
        Gets the closure_comment of this PrivilegedApiRequest.
        The comment entered by the operator while closing the request.


        :return: The closure_comment of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._closure_comment

    @closure_comment.setter
    def closure_comment(self, closure_comment):
        """
        Sets the closure_comment of this PrivilegedApiRequest.
        The comment entered by the operator while closing the request.


        :param closure_comment: The closure_comment of this PrivilegedApiRequest.
        :type: str
        """
        self._closure_comment = closure_comment

    @property
    def privileged_api_control_id(self):
        """
        Gets the privileged_api_control_id of this PrivilegedApiRequest.
        The OCID of the privilegedApi control governing the target resource.


        :return: The privileged_api_control_id of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._privileged_api_control_id

    @privileged_api_control_id.setter
    def privileged_api_control_id(self, privileged_api_control_id):
        """
        Sets the privileged_api_control_id of this PrivilegedApiRequest.
        The OCID of the privilegedApi control governing the target resource.


        :param privileged_api_control_id: The privileged_api_control_id of this PrivilegedApiRequest.
        :type: str
        """
        self._privileged_api_control_id = privileged_api_control_id

    @property
    def privileged_api_control_name(self):
        """
        Gets the privileged_api_control_name of this PrivilegedApiRequest.
        Name of the privilegedApi control governing the target resource.


        :return: The privileged_api_control_name of this PrivilegedApiRequest.
        :rtype: str
        """
        return self._privileged_api_control_name

    @privileged_api_control_name.setter
    def privileged_api_control_name(self, privileged_api_control_name):
        """
        Sets the privileged_api_control_name of this PrivilegedApiRequest.
        Name of the privilegedApi control governing the target resource.


        :param privileged_api_control_name: The privileged_api_control_name of this PrivilegedApiRequest.
        :type: str
        """
        self._privileged_api_control_name = privileged_api_control_name

    @property
    def number_of_approvers_required(self):
        """
        Gets the number_of_approvers_required of this PrivilegedApiRequest.
        Number of approvers required to approve an privilegedApi request.


        :return: The number_of_approvers_required of this PrivilegedApiRequest.
        :rtype: int
        """
        return self._number_of_approvers_required

    @number_of_approvers_required.setter
    def number_of_approvers_required(self, number_of_approvers_required):
        """
        Sets the number_of_approvers_required of this PrivilegedApiRequest.
        Number of approvers required to approve an privilegedApi request.


        :param number_of_approvers_required: The number_of_approvers_required of this PrivilegedApiRequest.
        :type: int
        """
        self._number_of_approvers_required = number_of_approvers_required

    @property
    def approver_details(self):
        """
        Gets the approver_details of this PrivilegedApiRequest.
        Contains the approver details who have approved the privilegedApi Request during the initial request.


        :return: The approver_details of this PrivilegedApiRequest.
        :rtype: list[oci.apiaccesscontrol.models.ApproverDetail]
        """
        return self._approver_details

    @approver_details.setter
    def approver_details(self, approver_details):
        """
        Sets the approver_details of this PrivilegedApiRequest.
        Contains the approver details who have approved the privilegedApi Request during the initial request.


        :param approver_details: The approver_details of this PrivilegedApiRequest.
        :type: list[oci.apiaccesscontrol.models.ApproverDetail]
        """
        self._approver_details = approver_details

    @property
    def time_requested_for_future_access(self):
        """
        Gets the time_requested_for_future_access of this PrivilegedApiRequest.
        Time in future when the user for the privilegedApi request needs to be created in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_requested_for_future_access of this PrivilegedApiRequest.
        :rtype: datetime
        """
        return self._time_requested_for_future_access

    @time_requested_for_future_access.setter
    def time_requested_for_future_access(self, time_requested_for_future_access):
        """
        Sets the time_requested_for_future_access of this PrivilegedApiRequest.
        Time in future when the user for the privilegedApi request needs to be created in `RFC 3339`__timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_requested_for_future_access: The time_requested_for_future_access of this PrivilegedApiRequest.
        :type: datetime
        """
        self._time_requested_for_future_access = time_requested_for_future_access

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this PrivilegedApiRequest.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this PrivilegedApiRequest.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PrivilegedApiRequest.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this PrivilegedApiRequest.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this PrivilegedApiRequest.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this PrivilegedApiRequest.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PrivilegedApiRequest.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this PrivilegedApiRequest.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this PrivilegedApiRequest.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this PrivilegedApiRequest.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PrivilegedApiRequest.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this PrivilegedApiRequest.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
