# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentConfigOverride(object):
    """
    Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgentConfigOverride object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param agent_filter:
            The value to assign to the agent_filter property of this AgentConfigOverride.
        :type agent_filter: str

        :param override_map:
            The value to assign to the override_map property of this AgentConfigOverride.
        :type override_map: dict(str, str)

        """
        self.swagger_types = {
            'agent_filter': 'str',
            'override_map': 'dict(str, str)'
        }
        self.attribute_map = {
            'agent_filter': 'agentFilter',
            'override_map': 'overrideMap'
        }
        self._agent_filter = None
        self._override_map = None

    @property
    def agent_filter(self):
        """
        Gets the agent_filter of this AgentConfigOverride.
        The string that defines the Agent Filter expression.


        :return: The agent_filter of this AgentConfigOverride.
        :rtype: str
        """
        return self._agent_filter

    @agent_filter.setter
    def agent_filter(self, agent_filter):
        """
        Sets the agent_filter of this AgentConfigOverride.
        The string that defines the Agent Filter expression.


        :param agent_filter: The agent_filter of this AgentConfigOverride.
        :type: str
        """
        self._agent_filter = agent_filter

    @property
    def override_map(self):
        """
        Gets the override_map of this AgentConfigOverride.
        A map whose key is a substitution variable specified within the configuration's body. For example, if below was specified in the configuration's body
        {{ isJfrEnabled | default false }}
        Then a valid map key would be \"isJfrEnabled\". The value is typically different than the default specified in the configuration's body.
        Thus, in this example, the map entry could be \"isJfrEnabled\": true


        :return: The override_map of this AgentConfigOverride.
        :rtype: dict(str, str)
        """
        return self._override_map

    @override_map.setter
    def override_map(self, override_map):
        """
        Sets the override_map of this AgentConfigOverride.
        A map whose key is a substitution variable specified within the configuration's body. For example, if below was specified in the configuration's body
        {{ isJfrEnabled | default false }}
        Then a valid map key would be \"isJfrEnabled\". The value is typically different than the default specified in the configuration's body.
        Thus, in this example, the map entry could be \"isJfrEnabled\": true


        :param override_map: The override_map of this AgentConfigOverride.
        :type: dict(str, str)
        """
        self._override_map = override_map

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
