# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportConfigurationDetails(object):
    """
    Array of configuration items with its dependencies to export.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExportConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param configuration_map:
            The value to assign to the configuration_map property of this ExportConfigurationDetails.
        :type configuration_map: dict(str, str)

        """
        self.swagger_types = {
            'configuration_map': 'dict(str, str)'
        }
        self.attribute_map = {
            'configuration_map': 'configurationMap'
        }
        self._configuration_map = None

    @property
    def configuration_map(self):
        """
        **[Required]** Gets the configuration_map of this ExportConfigurationDetails.
        Simple key-value pair that has parameters related to the export process (ConfigurationId, Skip, \u2026) and more.
        Example: `{\"parameter-key\": \"parameter-value\"}`
        Supported parameters:
        \u2014 List of the Configuration Type or Groups to Export to a destination domain.


        :return: The configuration_map of this ExportConfigurationDetails.
        :rtype: dict(str, str)
        """
        return self._configuration_map

    @configuration_map.setter
    def configuration_map(self, configuration_map):
        """
        Sets the configuration_map of this ExportConfigurationDetails.
        Simple key-value pair that has parameters related to the export process (ConfigurationId, Skip, \u2026) and more.
        Example: `{\"parameter-key\": \"parameter-value\"}`
        Supported parameters:
        \u2014 List of the Configuration Type or Groups to Export to a destination domain.


        :param configuration_map: The configuration_map of this ExportConfigurationDetails.
        :type: dict(str, str)
        """
        self._configuration_map = configuration_map

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
