# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ClientCertificateDetails(object):
    """
    Details for client certificate.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ClientCertificateDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param client_certificate:
            The value to assign to the client_certificate property of this ClientCertificateDetails.
        :type client_certificate: oci.apm_synthetics.models.ClientCertificate

        :param private_key:
            The value to assign to the private_key property of this ClientCertificateDetails.
        :type private_key: oci.apm_synthetics.models.PrivateKey

        """
        self.swagger_types = {
            'client_certificate': 'ClientCertificate',
            'private_key': 'PrivateKey'
        }
        self.attribute_map = {
            'client_certificate': 'clientCertificate',
            'private_key': 'privateKey'
        }
        self._client_certificate = None
        self._private_key = None

    @property
    def client_certificate(self):
        """
        Gets the client_certificate of this ClientCertificateDetails.

        :return: The client_certificate of this ClientCertificateDetails.
        :rtype: oci.apm_synthetics.models.ClientCertificate
        """
        return self._client_certificate

    @client_certificate.setter
    def client_certificate(self, client_certificate):
        """
        Sets the client_certificate of this ClientCertificateDetails.

        :param client_certificate: The client_certificate of this ClientCertificateDetails.
        :type: oci.apm_synthetics.models.ClientCertificate
        """
        self._client_certificate = client_certificate

    @property
    def private_key(self):
        """
        Gets the private_key of this ClientCertificateDetails.

        :return: The private_key of this ClientCertificateDetails.
        :rtype: oci.apm_synthetics.models.PrivateKey
        """
        return self._private_key

    @private_key.setter
    def private_key(self, private_key):
        """
        Sets the private_key of this ClientCertificateDetails.

        :param private_key: The private_key of this ClientCertificateDetails.
        :type: oci.apm_synthetics.models.PrivateKey
        """
        self._private_key = private_key

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
