# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdentityInfoDetails(object):
    """
    Domain details of the On-premise VP worker.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IdentityInfoDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region_name:
            The value to assign to the region_name property of this IdentityInfoDetails.
        :type region_name: str

        :param apm_short_id:
            The value to assign to the apm_short_id property of this IdentityInfoDetails.
        :type apm_short_id: str

        :param collector_end_point:
            The value to assign to the collector_end_point property of this IdentityInfoDetails.
        :type collector_end_point: str

        """
        self.swagger_types = {
            'region_name': 'str',
            'apm_short_id': 'str',
            'collector_end_point': 'str'
        }
        self.attribute_map = {
            'region_name': 'regionName',
            'apm_short_id': 'apmShortId',
            'collector_end_point': 'collectorEndPoint'
        }
        self._region_name = None
        self._apm_short_id = None
        self._collector_end_point = None

    @property
    def region_name(self):
        """
        **[Required]** Gets the region_name of this IdentityInfoDetails.
        Domain region of the On-premise VP worker.


        :return: The region_name of this IdentityInfoDetails.
        :rtype: str
        """
        return self._region_name

    @region_name.setter
    def region_name(self, region_name):
        """
        Sets the region_name of this IdentityInfoDetails.
        Domain region of the On-premise VP worker.


        :param region_name: The region_name of this IdentityInfoDetails.
        :type: str
        """
        self._region_name = region_name

    @property
    def apm_short_id(self):
        """
        **[Required]** Gets the apm_short_id of this IdentityInfoDetails.
        Domain short id of the On-premise VP worker.


        :return: The apm_short_id of this IdentityInfoDetails.
        :rtype: str
        """
        return self._apm_short_id

    @apm_short_id.setter
    def apm_short_id(self, apm_short_id):
        """
        Sets the apm_short_id of this IdentityInfoDetails.
        Domain short id of the On-premise VP worker.


        :param apm_short_id: The apm_short_id of this IdentityInfoDetails.
        :type: str
        """
        self._apm_short_id = apm_short_id

    @property
    def collector_end_point(self):
        """
        **[Required]** Gets the collector_end_point of this IdentityInfoDetails.
        Collector endpoint of the On-premise VP worker.


        :return: The collector_end_point of this IdentityInfoDetails.
        :rtype: str
        """
        return self._collector_end_point

    @collector_end_point.setter
    def collector_end_point(self, collector_end_point):
        """
        Sets the collector_end_point of this IdentityInfoDetails.
        Collector endpoint of the On-premise VP worker.


        :param collector_end_point: The collector_end_point of this IdentityInfoDetails.
        :type: str
        """
        self._collector_end_point = collector_end_point

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
