# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WorkersSummary(object):
    """
    Details of the workers in a specific On-premise vantage point.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new WorkersSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total:
            The value to assign to the total property of this WorkersSummary.
        :type total: int

        :param available:
            The value to assign to the available property of this WorkersSummary.
        :type available: int

        :param used:
            The value to assign to the used property of this WorkersSummary.
        :type used: int

        :param disabled:
            The value to assign to the disabled property of this WorkersSummary.
        :type disabled: int

        :param min_version:
            The value to assign to the min_version property of this WorkersSummary.
        :type min_version: str

        :param available_capabilities:
            The value to assign to the available_capabilities property of this WorkersSummary.
        :type available_capabilities: list[oci.apm_synthetics.models.AvailableCapability]

        """
        self.swagger_types = {
            'total': 'int',
            'available': 'int',
            'used': 'int',
            'disabled': 'int',
            'min_version': 'str',
            'available_capabilities': 'list[AvailableCapability]'
        }
        self.attribute_map = {
            'total': 'total',
            'available': 'available',
            'used': 'used',
            'disabled': 'disabled',
            'min_version': 'minVersion',
            'available_capabilities': 'availableCapabilities'
        }
        self._total = None
        self._available = None
        self._used = None
        self._disabled = None
        self._min_version = None
        self._available_capabilities = None

    @property
    def total(self):
        """
        **[Required]** Gets the total of this WorkersSummary.
        Total number of workers in a specific On-premise vantage point.


        :return: The total of this WorkersSummary.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        """
        Sets the total of this WorkersSummary.
        Total number of workers in a specific On-premise vantage point.


        :param total: The total of this WorkersSummary.
        :type: int
        """
        self._total = total

    @property
    def available(self):
        """
        **[Required]** Gets the available of this WorkersSummary.
        Number of available workers in a specific On-premise vantage point.


        :return: The available of this WorkersSummary.
        :rtype: int
        """
        return self._available

    @available.setter
    def available(self, available):
        """
        Sets the available of this WorkersSummary.
        Number of available workers in a specific On-premise vantage point.


        :param available: The available of this WorkersSummary.
        :type: int
        """
        self._available = available

    @property
    def used(self):
        """
        **[Required]** Gets the used of this WorkersSummary.
        Number of occupied workers in a specific On-premise vantage point.


        :return: The used of this WorkersSummary.
        :rtype: int
        """
        return self._used

    @used.setter
    def used(self, used):
        """
        Sets the used of this WorkersSummary.
        Number of occupied workers in a specific On-premise vantage point.


        :param used: The used of this WorkersSummary.
        :type: int
        """
        self._used = used

    @property
    def disabled(self):
        """
        **[Required]** Gets the disabled of this WorkersSummary.
        Number of disabled workers in a specific On-premise vantage point.


        :return: The disabled of this WorkersSummary.
        :rtype: int
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        """
        Sets the disabled of this WorkersSummary.
        Number of disabled workers in a specific On-premise vantage point.


        :param disabled: The disabled of this WorkersSummary.
        :type: int
        """
        self._disabled = disabled

    @property
    def min_version(self):
        """
        **[Required]** Gets the min_version of this WorkersSummary.
        Minimum version among the workers in a specific On-premise vantage point.


        :return: The min_version of this WorkersSummary.
        :rtype: str
        """
        return self._min_version

    @min_version.setter
    def min_version(self, min_version):
        """
        Sets the min_version of this WorkersSummary.
        Minimum version among the workers in a specific On-premise vantage point.


        :param min_version: The min_version of this WorkersSummary.
        :type: str
        """
        self._min_version = min_version

    @property
    def available_capabilities(self):
        """
        **[Required]** Gets the available_capabilities of this WorkersSummary.
        List of available capabilities in a specific On-premise vantage point.


        :return: The available_capabilities of this WorkersSummary.
        :rtype: list[oci.apm_synthetics.models.AvailableCapability]
        """
        return self._available_capabilities

    @available_capabilities.setter
    def available_capabilities(self, available_capabilities):
        """
        Sets the available_capabilities of this WorkersSummary.
        List of available capabilities in a specific On-premise vantage point.


        :param available_capabilities: The available_capabilities of this WorkersSummary.
        :type: list[oci.apm_synthetics.models.AvailableCapability]
        """
        self._available_capabilities = available_capabilities

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
