# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorage(object):
    """
    Definition of the object storage.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param bucket_name:
            The value to assign to the bucket_name property of this ObjectStorage.
        :type bucket_name: str

        :param name_space:
            The value to assign to the name_space property of this ObjectStorage.
        :type name_space: str

        :param object_name_prefix:
            The value to assign to the object_name_prefix property of this ObjectStorage.
        :type object_name_prefix: str

        """
        self.swagger_types = {
            'bucket_name': 'str',
            'name_space': 'str',
            'object_name_prefix': 'str'
        }
        self.attribute_map = {
            'bucket_name': 'bucketName',
            'name_space': 'nameSpace',
            'object_name_prefix': 'objectNamePrefix'
        }
        self._bucket_name = None
        self._name_space = None
        self._object_name_prefix = None

    @property
    def bucket_name(self):
        """
        Gets the bucket_name of this ObjectStorage.
        Bucket name in the object store.


        :return: The bucket_name of this ObjectStorage.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ObjectStorage.
        Bucket name in the object store.


        :param bucket_name: The bucket_name of this ObjectStorage.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def name_space(self):
        """
        Gets the name_space of this ObjectStorage.
        Namespace in the object store.


        :return: The name_space of this ObjectStorage.
        :rtype: str
        """
        return self._name_space

    @name_space.setter
    def name_space(self, name_space):
        """
        Sets the name_space of this ObjectStorage.
        Namespace in the object store.


        :param name_space: The name_space of this ObjectStorage.
        :type: str
        """
        self._name_space = name_space

    @property
    def object_name_prefix(self):
        """
        Gets the object_name_prefix of this ObjectStorage.
        Object name prefix in the object store.


        :return: The object_name_prefix of this ObjectStorage.
        :rtype: str
        """
        return self._object_name_prefix

    @object_name_prefix.setter
    def object_name_prefix(self, object_name_prefix):
        """
        Sets the object_name_prefix of this ObjectStorage.
        Object name prefix in the object store.


        :param object_name_prefix: The object_name_prefix of this ObjectStorage.
        :type: str
        """
        self._object_name_prefix = object_name_prefix

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
