# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchContext(object):
    """
    Representation of a batch context and its configurations.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a BatchContext.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a BatchContext.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a BatchContext.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a BatchContext.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a BatchContext.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a BatchContext.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a BatchContext.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a BatchContext.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new BatchContext object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BatchContext.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this BatchContext.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this BatchContext.
        :type display_name: str

        :param description:
            The value to assign to the description property of this BatchContext.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this BatchContext.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this BatchContext.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this BatchContext.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this BatchContext.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this BatchContext.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this BatchContext.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this BatchContext.
        :type system_tags: dict(str, dict(str, object))

        :param job_priority_configurations:
            The value to assign to the job_priority_configurations property of this BatchContext.
        :type job_priority_configurations: list[oci.batch.models.JobPriorityConfiguration]

        :param network:
            The value to assign to the network property of this BatchContext.
        :type network: oci.batch.models.Network

        :param fleets:
            The value to assign to the fleets property of this BatchContext.
        :type fleets: list[oci.batch.models.Fleet]

        :param entitlements:
            The value to assign to the entitlements property of this BatchContext.
        :type entitlements: dict(str, int)

        :param logging_configuration:
            The value to assign to the logging_configuration property of this BatchContext.
        :type logging_configuration: oci.batch.models.LoggingConfiguration

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'job_priority_configurations': 'list[JobPriorityConfiguration]',
            'network': 'Network',
            'fleets': 'list[Fleet]',
            'entitlements': 'dict(str, int)',
            'logging_configuration': 'LoggingConfiguration'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'job_priority_configurations': 'jobPriorityConfigurations',
            'network': 'network',
            'fleets': 'fleets',
            'entitlements': 'entitlements',
            'logging_configuration': 'loggingConfiguration'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._job_priority_configurations = None
        self._network = None
        self._fleets = None
        self._entitlements = None
        self._logging_configuration = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this BatchContext.
        The `OCID`__ of the batch context.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this BatchContext.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BatchContext.
        The `OCID`__ of the batch context.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this BatchContext.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this BatchContext.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this BatchContext.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BatchContext.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this BatchContext.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this BatchContext.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this BatchContext.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this BatchContext.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this BatchContext.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this BatchContext.
        Summarized information about the batch context.


        :return: The description of this BatchContext.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BatchContext.
        Summarized information about the batch context.


        :param description: The description of this BatchContext.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this BatchContext.
        The date and time the batch context was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this BatchContext.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this BatchContext.
        The date and time the batch context was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this BatchContext.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this BatchContext.
        The date and time the batch context was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this BatchContext.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this BatchContext.
        The date and time the batch context was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this BatchContext.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this BatchContext.
        The current state of the batch context.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this BatchContext.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this BatchContext.
        The current state of the batch context.


        :param lifecycle_state: The lifecycle_state of this BatchContext.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this BatchContext.
        A message that describes the current state in more detail. For example,   can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this BatchContext.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this BatchContext.
        A message that describes the current state in more detail. For example,   can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this BatchContext.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this BatchContext.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this BatchContext.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this BatchContext.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this BatchContext.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this BatchContext.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this BatchContext.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this BatchContext.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this BatchContext.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        **[Required]** Gets the system_tags of this BatchContext.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this BatchContext.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this BatchContext.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this BatchContext.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def job_priority_configurations(self):
        """
        **[Required]** Gets the job_priority_configurations of this BatchContext.
        List of job priority configurations related to the batch context.


        :return: The job_priority_configurations of this BatchContext.
        :rtype: list[oci.batch.models.JobPriorityConfiguration]
        """
        return self._job_priority_configurations

    @job_priority_configurations.setter
    def job_priority_configurations(self, job_priority_configurations):
        """
        Sets the job_priority_configurations of this BatchContext.
        List of job priority configurations related to the batch context.


        :param job_priority_configurations: The job_priority_configurations of this BatchContext.
        :type: list[oci.batch.models.JobPriorityConfiguration]
        """
        self._job_priority_configurations = job_priority_configurations

    @property
    def network(self):
        """
        **[Required]** Gets the network of this BatchContext.

        :return: The network of this BatchContext.
        :rtype: oci.batch.models.Network
        """
        return self._network

    @network.setter
    def network(self, network):
        """
        Sets the network of this BatchContext.

        :param network: The network of this BatchContext.
        :type: oci.batch.models.Network
        """
        self._network = network

    @property
    def fleets(self):
        """
        **[Required]** Gets the fleets of this BatchContext.
        List of fleet configurations related to the batch context.


        :return: The fleets of this BatchContext.
        :rtype: list[oci.batch.models.Fleet]
        """
        return self._fleets

    @fleets.setter
    def fleets(self, fleets):
        """
        Sets the fleets of this BatchContext.
        List of fleet configurations related to the batch context.


        :param fleets: The fleets of this BatchContext.
        :type: list[oci.batch.models.Fleet]
        """
        self._fleets = fleets

    @property
    def entitlements(self):
        """
        **[Required]** Gets the entitlements of this BatchContext.
        Mapping of concurrent/shared resources used in job tasks to their limits.


        :return: The entitlements of this BatchContext.
        :rtype: dict(str, int)
        """
        return self._entitlements

    @entitlements.setter
    def entitlements(self, entitlements):
        """
        Sets the entitlements of this BatchContext.
        Mapping of concurrent/shared resources used in job tasks to their limits.


        :param entitlements: The entitlements of this BatchContext.
        :type: dict(str, int)
        """
        self._entitlements = entitlements

    @property
    def logging_configuration(self):
        """
        Gets the logging_configuration of this BatchContext.

        :return: The logging_configuration of this BatchContext.
        :rtype: oci.batch.models.LoggingConfiguration
        """
        return self._logging_configuration

    @logging_configuration.setter
    def logging_configuration(self, logging_configuration):
        """
        Sets the logging_configuration of this BatchContext.

        :param logging_configuration: The logging_configuration of this BatchContext.
        :type: oci.batch.models.LoggingConfiguration
        """
        self._logging_configuration = logging_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
