# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ActivateUpstConfigurationDetails(object):
    """
    Details for activating UPST config on the cluster
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ActivateUpstConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_admin_password:
            The value to assign to the cluster_admin_password property of this ActivateUpstConfigurationDetails.
        :type cluster_admin_password: str

        :param vault_id:
            The value to assign to the vault_id property of this ActivateUpstConfigurationDetails.
        :type vault_id: str

        :param master_encryption_key_id:
            The value to assign to the master_encryption_key_id property of this ActivateUpstConfigurationDetails.
        :type master_encryption_key_id: str

        """
        self.swagger_types = {
            'cluster_admin_password': 'str',
            'vault_id': 'str',
            'master_encryption_key_id': 'str'
        }
        self.attribute_map = {
            'cluster_admin_password': 'clusterAdminPassword',
            'vault_id': 'vaultId',
            'master_encryption_key_id': 'masterEncryptionKeyId'
        }
        self._cluster_admin_password = None
        self._vault_id = None
        self._master_encryption_key_id = None

    @property
    def cluster_admin_password(self):
        """
        **[Required]** Gets the cluster_admin_password of this ActivateUpstConfigurationDetails.
        Base-64 encoded password for the cluster admin user.


        :return: The cluster_admin_password of this ActivateUpstConfigurationDetails.
        :rtype: str
        """
        return self._cluster_admin_password

    @cluster_admin_password.setter
    def cluster_admin_password(self, cluster_admin_password):
        """
        Sets the cluster_admin_password of this ActivateUpstConfigurationDetails.
        Base-64 encoded password for the cluster admin user.


        :param cluster_admin_password: The cluster_admin_password of this ActivateUpstConfigurationDetails.
        :type: str
        """
        self._cluster_admin_password = cluster_admin_password

    @property
    def vault_id(self):
        """
        **[Required]** Gets the vault_id of this ActivateUpstConfigurationDetails.
        OCID of the vault to store token exchange service principal keyta, required for creating UPST configb


        :return: The vault_id of this ActivateUpstConfigurationDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this ActivateUpstConfigurationDetails.
        OCID of the vault to store token exchange service principal keyta, required for creating UPST configb


        :param vault_id: The vault_id of this ActivateUpstConfigurationDetails.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def master_encryption_key_id(self):
        """
        **[Required]** Gets the master_encryption_key_id of this ActivateUpstConfigurationDetails.
        OCID of the master encryption key in vault for encrypting token exchange service principal keytab, required for creating UPST config


        :return: The master_encryption_key_id of this ActivateUpstConfigurationDetails.
        :rtype: str
        """
        return self._master_encryption_key_id

    @master_encryption_key_id.setter
    def master_encryption_key_id(self, master_encryption_key_id):
        """
        Sets the master_encryption_key_id of this ActivateUpstConfigurationDetails.
        OCID of the master encryption key in vault for encrypting token exchange service principal keytab, required for creating UPST config


        :param master_encryption_key_id: The master_encryption_key_id of this ActivateUpstConfigurationDetails.
        :type: str
        """
        self._master_encryption_key_id = master_encryption_key_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
