# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CapacityReportShapeAvailability(object):
    """
    Detailed information about the availabilities of a shape in each domain.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CapacityReportShapeAvailability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param shape:
            The value to assign to the shape property of this CapacityReportShapeAvailability.
        :type shape: str

        :param shape_config:
            The value to assign to the shape_config property of this CapacityReportShapeAvailability.
        :type shape_config: oci.bds.models.ShapeConfigDetails

        :param domain_level_capacity_reports:
            The value to assign to the domain_level_capacity_reports property of this CapacityReportShapeAvailability.
        :type domain_level_capacity_reports: list[oci.bds.models.DomainTypeCapacityReport]

        """
        self.swagger_types = {
            'shape': 'str',
            'shape_config': 'ShapeConfigDetails',
            'domain_level_capacity_reports': 'list[DomainTypeCapacityReport]'
        }
        self.attribute_map = {
            'shape': 'shape',
            'shape_config': 'shapeConfig',
            'domain_level_capacity_reports': 'domainLevelCapacityReports'
        }
        self._shape = None
        self._shape_config = None
        self._domain_level_capacity_reports = None

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this CapacityReportShapeAvailability.
        The shape that the capacity report was requested for.


        :return: The shape of this CapacityReportShapeAvailability.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this CapacityReportShapeAvailability.
        The shape that the capacity report was requested for.


        :param shape: The shape of this CapacityReportShapeAvailability.
        :type: str
        """
        self._shape = shape

    @property
    def shape_config(self):
        """
        Gets the shape_config of this CapacityReportShapeAvailability.

        :return: The shape_config of this CapacityReportShapeAvailability.
        :rtype: oci.bds.models.ShapeConfigDetails
        """
        return self._shape_config

    @shape_config.setter
    def shape_config(self, shape_config):
        """
        Sets the shape_config of this CapacityReportShapeAvailability.

        :param shape_config: The shape_config of this CapacityReportShapeAvailability.
        :type: oci.bds.models.ShapeConfigDetails
        """
        self._shape_config = shape_config

    @property
    def domain_level_capacity_reports(self):
        """
        **[Required]** Gets the domain_level_capacity_reports of this CapacityReportShapeAvailability.
        Information about the capacity in each domain.


        :return: The domain_level_capacity_reports of this CapacityReportShapeAvailability.
        :rtype: list[oci.bds.models.DomainTypeCapacityReport]
        """
        return self._domain_level_capacity_reports

    @domain_level_capacity_reports.setter
    def domain_level_capacity_reports(self, domain_level_capacity_reports):
        """
        Sets the domain_level_capacity_reports of this CapacityReportShapeAvailability.
        Information about the capacity in each domain.


        :param domain_level_capacity_reports: The domain_level_capacity_reports of this CapacityReportShapeAvailability.
        :type: list[oci.bds.models.DomainTypeCapacityReport]
        """
        self._domain_level_capacity_reports = domain_level_capacity_reports

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
