# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateIdentityConfigurationDetails(object):
    """
    Details for creating the identity configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateIdentityConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_admin_password:
            The value to assign to the cluster_admin_password property of this CreateIdentityConfigurationDetails.
        :type cluster_admin_password: str

        :param display_name:
            The value to assign to the display_name property of this CreateIdentityConfigurationDetails.
        :type display_name: str

        :param identity_domain_id:
            The value to assign to the identity_domain_id property of this CreateIdentityConfigurationDetails.
        :type identity_domain_id: str

        :param confidential_application_id:
            The value to assign to the confidential_application_id property of this CreateIdentityConfigurationDetails.
        :type confidential_application_id: str

        :param upst_configuration_details:
            The value to assign to the upst_configuration_details property of this CreateIdentityConfigurationDetails.
        :type upst_configuration_details: oci.bds.models.UpstConfigurationDetails

        :param iam_user_sync_configuration_details:
            The value to assign to the iam_user_sync_configuration_details property of this CreateIdentityConfigurationDetails.
        :type iam_user_sync_configuration_details: oci.bds.models.IamUserSyncConfigurationDetails

        """
        self.swagger_types = {
            'cluster_admin_password': 'str',
            'display_name': 'str',
            'identity_domain_id': 'str',
            'confidential_application_id': 'str',
            'upst_configuration_details': 'UpstConfigurationDetails',
            'iam_user_sync_configuration_details': 'IamUserSyncConfigurationDetails'
        }
        self.attribute_map = {
            'cluster_admin_password': 'clusterAdminPassword',
            'display_name': 'displayName',
            'identity_domain_id': 'identityDomainId',
            'confidential_application_id': 'confidentialApplicationId',
            'upst_configuration_details': 'upstConfigurationDetails',
            'iam_user_sync_configuration_details': 'iamUserSyncConfigurationDetails'
        }
        self._cluster_admin_password = None
        self._display_name = None
        self._identity_domain_id = None
        self._confidential_application_id = None
        self._upst_configuration_details = None
        self._iam_user_sync_configuration_details = None

    @property
    def cluster_admin_password(self):
        """
        **[Required]** Gets the cluster_admin_password of this CreateIdentityConfigurationDetails.
        Base-64 encoded password for the cluster admin user.


        :return: The cluster_admin_password of this CreateIdentityConfigurationDetails.
        :rtype: str
        """
        return self._cluster_admin_password

    @cluster_admin_password.setter
    def cluster_admin_password(self, cluster_admin_password):
        """
        Sets the cluster_admin_password of this CreateIdentityConfigurationDetails.
        Base-64 encoded password for the cluster admin user.


        :param cluster_admin_password: The cluster_admin_password of this CreateIdentityConfigurationDetails.
        :type: str
        """
        self._cluster_admin_password = cluster_admin_password

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateIdentityConfigurationDetails.
        Display name of the identity configuration, required for creating identity configuration.


        :return: The display_name of this CreateIdentityConfigurationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateIdentityConfigurationDetails.
        Display name of the identity configuration, required for creating identity configuration.


        :param display_name: The display_name of this CreateIdentityConfigurationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def identity_domain_id(self):
        """
        **[Required]** Gets the identity_domain_id of this CreateIdentityConfigurationDetails.
        Identity domain OCID to use for identity config, required for creating identity configuration


        :return: The identity_domain_id of this CreateIdentityConfigurationDetails.
        :rtype: str
        """
        return self._identity_domain_id

    @identity_domain_id.setter
    def identity_domain_id(self, identity_domain_id):
        """
        Sets the identity_domain_id of this CreateIdentityConfigurationDetails.
        Identity domain OCID to use for identity config, required for creating identity configuration


        :param identity_domain_id: The identity_domain_id of this CreateIdentityConfigurationDetails.
        :type: str
        """
        self._identity_domain_id = identity_domain_id

    @property
    def confidential_application_id(self):
        """
        **[Required]** Gets the confidential_application_id of this CreateIdentityConfigurationDetails.
        Identity domain confidential application ID for the identity config, required for creating identity configuration


        :return: The confidential_application_id of this CreateIdentityConfigurationDetails.
        :rtype: str
        """
        return self._confidential_application_id

    @confidential_application_id.setter
    def confidential_application_id(self, confidential_application_id):
        """
        Sets the confidential_application_id of this CreateIdentityConfigurationDetails.
        Identity domain confidential application ID for the identity config, required for creating identity configuration


        :param confidential_application_id: The confidential_application_id of this CreateIdentityConfigurationDetails.
        :type: str
        """
        self._confidential_application_id = confidential_application_id

    @property
    def upst_configuration_details(self):
        """
        Gets the upst_configuration_details of this CreateIdentityConfigurationDetails.

        :return: The upst_configuration_details of this CreateIdentityConfigurationDetails.
        :rtype: oci.bds.models.UpstConfigurationDetails
        """
        return self._upst_configuration_details

    @upst_configuration_details.setter
    def upst_configuration_details(self, upst_configuration_details):
        """
        Sets the upst_configuration_details of this CreateIdentityConfigurationDetails.

        :param upst_configuration_details: The upst_configuration_details of this CreateIdentityConfigurationDetails.
        :type: oci.bds.models.UpstConfigurationDetails
        """
        self._upst_configuration_details = upst_configuration_details

    @property
    def iam_user_sync_configuration_details(self):
        """
        Gets the iam_user_sync_configuration_details of this CreateIdentityConfigurationDetails.

        :return: The iam_user_sync_configuration_details of this CreateIdentityConfigurationDetails.
        :rtype: oci.bds.models.IamUserSyncConfigurationDetails
        """
        return self._iam_user_sync_configuration_details

    @iam_user_sync_configuration_details.setter
    def iam_user_sync_configuration_details(self, iam_user_sync_configuration_details):
        """
        Sets the iam_user_sync_configuration_details of this CreateIdentityConfigurationDetails.

        :param iam_user_sync_configuration_details: The iam_user_sync_configuration_details of this CreateIdentityConfigurationDetails.
        :type: oci.bds.models.IamUserSyncConfigurationDetails
        """
        self._iam_user_sync_configuration_details = iam_user_sync_configuration_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
