# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NodeBackup(object):
    """
    The information about the Node's backup.
    """

    #: A constant which can be used with the backup_trigger_type property of a NodeBackup.
    #: This constant has a value of "MANUAL"
    BACKUP_TRIGGER_TYPE_MANUAL = "MANUAL"

    #: A constant which can be used with the backup_trigger_type property of a NodeBackup.
    #: This constant has a value of "SCHEDULED"
    BACKUP_TRIGGER_TYPE_SCHEDULED = "SCHEDULED"

    #: A constant which can be used with the backup_type property of a NodeBackup.
    #: This constant has a value of "FULL"
    BACKUP_TYPE_FULL = "FULL"

    #: A constant which can be used with the backup_type property of a NodeBackup.
    #: This constant has a value of "INCREMENTAL"
    BACKUP_TYPE_INCREMENTAL = "INCREMENTAL"

    #: A constant which can be used with the lifecycle_state property of a NodeBackup.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a NodeBackup.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a NodeBackup.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a NodeBackup.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a NodeBackup.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a NodeBackup.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a NodeBackup.
    #: This constant has a value of "PARTIAL"
    LIFECYCLE_STATE_PARTIAL = "PARTIAL"

    def __init__(self, **kwargs):
        """
        Initializes a new NodeBackup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this NodeBackup.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this NodeBackup.
        :type display_name: str

        :param node_instance_id:
            The value to assign to the node_instance_id property of this NodeBackup.
        :type node_instance_id: str

        :param node_host_name:
            The value to assign to the node_host_name property of this NodeBackup.
        :type node_host_name: str

        :param backup_trigger_type:
            The value to assign to the backup_trigger_type property of this NodeBackup.
            Allowed values for this property are: "MANUAL", "SCHEDULED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type backup_trigger_type: str

        :param node_backup_config_id:
            The value to assign to the node_backup_config_id property of this NodeBackup.
        :type node_backup_config_id: str

        :param backup_type:
            The value to assign to the backup_type property of this NodeBackup.
            Allowed values for this property are: "FULL", "INCREMENTAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type backup_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this NodeBackup.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", "PARTIAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this NodeBackup.
        :type time_created: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'node_instance_id': 'str',
            'node_host_name': 'str',
            'backup_trigger_type': 'str',
            'node_backup_config_id': 'str',
            'backup_type': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'node_instance_id': 'nodeInstanceId',
            'node_host_name': 'nodeHostName',
            'backup_trigger_type': 'backupTriggerType',
            'node_backup_config_id': 'nodeBackupConfigId',
            'backup_type': 'backupType',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated'
        }
        self._id = None
        self._display_name = None
        self._node_instance_id = None
        self._node_host_name = None
        self._backup_trigger_type = None
        self._node_backup_config_id = None
        self._backup_type = None
        self._lifecycle_state = None
        self._time_created = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this NodeBackup.
        The id of the node backup.


        :return: The id of this NodeBackup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NodeBackup.
        The id of the node backup.


        :param id: The id of this NodeBackup.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this NodeBackup.
        BDS generated name for the backup. Format is nodeHostName_timeCreated


        :return: The display_name of this NodeBackup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this NodeBackup.
        BDS generated name for the backup. Format is nodeHostName_timeCreated


        :param display_name: The display_name of this NodeBackup.
        :type: str
        """
        self._display_name = display_name

    @property
    def node_instance_id(self):
        """
        **[Required]** Gets the node_instance_id of this NodeBackup.
        The instance OCID of the node, which is the resource from which the node backup was acquired.


        :return: The node_instance_id of this NodeBackup.
        :rtype: str
        """
        return self._node_instance_id

    @node_instance_id.setter
    def node_instance_id(self, node_instance_id):
        """
        Sets the node_instance_id of this NodeBackup.
        The instance OCID of the node, which is the resource from which the node backup was acquired.


        :param node_instance_id: The node_instance_id of this NodeBackup.
        :type: str
        """
        self._node_instance_id = node_instance_id

    @property
    def node_host_name(self):
        """
        **[Required]** Gets the node_host_name of this NodeBackup.
        Host name of the node to which this backup belongs.


        :return: The node_host_name of this NodeBackup.
        :rtype: str
        """
        return self._node_host_name

    @node_host_name.setter
    def node_host_name(self, node_host_name):
        """
        Sets the node_host_name of this NodeBackup.
        Host name of the node to which this backup belongs.


        :param node_host_name: The node_host_name of this NodeBackup.
        :type: str
        """
        self._node_host_name = node_host_name

    @property
    def backup_trigger_type(self):
        """
        **[Required]** Gets the backup_trigger_type of this NodeBackup.
        type based on how backup action was initiated.

        Allowed values for this property are: "MANUAL", "SCHEDULED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The backup_trigger_type of this NodeBackup.
        :rtype: str
        """
        return self._backup_trigger_type

    @backup_trigger_type.setter
    def backup_trigger_type(self, backup_trigger_type):
        """
        Sets the backup_trigger_type of this NodeBackup.
        type based on how backup action was initiated.


        :param backup_trigger_type: The backup_trigger_type of this NodeBackup.
        :type: str
        """
        allowed_values = ["MANUAL", "SCHEDULED"]
        if not value_allowed_none_or_none_sentinel(backup_trigger_type, allowed_values):
            backup_trigger_type = 'UNKNOWN_ENUM_VALUE'
        self._backup_trigger_type = backup_trigger_type

    @property
    def node_backup_config_id(self):
        """
        Gets the node_backup_config_id of this NodeBackup.
        The ID of the nodeBackupConfiguration if the NodeBackup is automatically created by applying the configuration.


        :return: The node_backup_config_id of this NodeBackup.
        :rtype: str
        """
        return self._node_backup_config_id

    @node_backup_config_id.setter
    def node_backup_config_id(self, node_backup_config_id):
        """
        Sets the node_backup_config_id of this NodeBackup.
        The ID of the nodeBackupConfiguration if the NodeBackup is automatically created by applying the configuration.


        :param node_backup_config_id: The node_backup_config_id of this NodeBackup.
        :type: str
        """
        self._node_backup_config_id = node_backup_config_id

    @property
    def backup_type(self):
        """
        **[Required]** Gets the backup_type of this NodeBackup.
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.

        Allowed values for this property are: "FULL", "INCREMENTAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The backup_type of this NodeBackup.
        :rtype: str
        """
        return self._backup_type

    @backup_type.setter
    def backup_type(self, backup_type):
        """
        Sets the backup_type of this NodeBackup.
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.


        :param backup_type: The backup_type of this NodeBackup.
        :type: str
        """
        allowed_values = ["FULL", "INCREMENTAL"]
        if not value_allowed_none_or_none_sentinel(backup_type, allowed_values):
            backup_type = 'UNKNOWN_ENUM_VALUE'
        self._backup_type = backup_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this NodeBackup.
        The state of the NodeBackup.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", "PARTIAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this NodeBackup.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this NodeBackup.
        The state of the NodeBackup.


        :param lifecycle_state: The lifecycle_state of this NodeBackup.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", "PARTIAL"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this NodeBackup.
        The time the cluster was created, shown as an RFC 3339 formatted datetime string.


        :return: The time_created of this NodeBackup.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this NodeBackup.
        The time the cluster was created, shown as an RFC 3339 formatted datetime string.


        :param time_created: The time_created of this NodeBackup.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
