# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SoftwareUpdate(object):
    """
    Details about the given software update.
    """

    #: A constant which can be used with the software_update_type property of a SoftwareUpdate.
    #: This constant has a value of "BDS"
    SOFTWARE_UPDATE_TYPE_BDS = "BDS"

    #: A constant which can be used with the lifecycle_state property of a SoftwareUpdate.
    #: This constant has a value of "WAITING"
    LIFECYCLE_STATE_WAITING = "WAITING"

    #: A constant which can be used with the lifecycle_state property of a SoftwareUpdate.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a SoftwareUpdate.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a SoftwareUpdate.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a SoftwareUpdate.
    #: This constant has a value of "CANCELED"
    LIFECYCLE_STATE_CANCELED = "CANCELED"

    def __init__(self, **kwargs):
        """
        Initializes a new SoftwareUpdate object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.bds.models.BdsSoftwareUpdate`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param software_update_key:
            The value to assign to the software_update_key property of this SoftwareUpdate.
        :type software_update_key: str

        :param software_update_version:
            The value to assign to the software_update_version property of this SoftwareUpdate.
        :type software_update_version: str

        :param time_released:
            The value to assign to the time_released property of this SoftwareUpdate.
        :type time_released: datetime

        :param software_update_type:
            The value to assign to the software_update_type property of this SoftwareUpdate.
            Allowed values for this property are: "BDS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type software_update_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SoftwareUpdate.
            Allowed values for this property are: "WAITING", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'software_update_key': 'str',
            'software_update_version': 'str',
            'time_released': 'datetime',
            'software_update_type': 'str',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'software_update_key': 'softwareUpdateKey',
            'software_update_version': 'softwareUpdateVersion',
            'time_released': 'timeReleased',
            'software_update_type': 'softwareUpdateType',
            'lifecycle_state': 'lifecycleState'
        }
        self._software_update_key = None
        self._software_update_version = None
        self._time_released = None
        self._software_update_type = None
        self._lifecycle_state = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['softwareUpdateType']

        if type == 'BDS':
            return 'BdsSoftwareUpdate'
        else:
            return 'SoftwareUpdate'

    @property
    def software_update_key(self):
        """
        **[Required]** Gets the software_update_key of this SoftwareUpdate.
        Unique identifier of a given software update


        :return: The software_update_key of this SoftwareUpdate.
        :rtype: str
        """
        return self._software_update_key

    @software_update_key.setter
    def software_update_key(self, software_update_key):
        """
        Sets the software_update_key of this SoftwareUpdate.
        Unique identifier of a given software update


        :param software_update_key: The software_update_key of this SoftwareUpdate.
        :type: str
        """
        self._software_update_key = software_update_key

    @property
    def software_update_version(self):
        """
        **[Required]** Gets the software_update_version of this SoftwareUpdate.
        The version of the software update.


        :return: The software_update_version of this SoftwareUpdate.
        :rtype: str
        """
        return self._software_update_version

    @software_update_version.setter
    def software_update_version(self, software_update_version):
        """
        Sets the software_update_version of this SoftwareUpdate.
        The version of the software update.


        :param software_update_version: The software_update_version of this SoftwareUpdate.
        :type: str
        """
        self._software_update_version = software_update_version

    @property
    def time_released(self):
        """
        **[Required]** Gets the time_released of this SoftwareUpdate.
        The time when the software update was released.


        :return: The time_released of this SoftwareUpdate.
        :rtype: datetime
        """
        return self._time_released

    @time_released.setter
    def time_released(self, time_released):
        """
        Sets the time_released of this SoftwareUpdate.
        The time when the software update was released.


        :param time_released: The time_released of this SoftwareUpdate.
        :type: datetime
        """
        self._time_released = time_released

    @property
    def software_update_type(self):
        """
        **[Required]** Gets the software_update_type of this SoftwareUpdate.
        type of current software update.
        - Big Data Service's micro service. BDS version will be changed after upgrade.

        Allowed values for this property are: "BDS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The software_update_type of this SoftwareUpdate.
        :rtype: str
        """
        return self._software_update_type

    @software_update_type.setter
    def software_update_type(self, software_update_type):
        """
        Sets the software_update_type of this SoftwareUpdate.
        type of current software update.
        - Big Data Service's micro service. BDS version will be changed after upgrade.


        :param software_update_type: The software_update_type of this SoftwareUpdate.
        :type: str
        """
        allowed_values = ["BDS"]
        if not value_allowed_none_or_none_sentinel(software_update_type, allowed_values):
            software_update_type = 'UNKNOWN_ENUM_VALUE'
        self._software_update_type = software_update_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SoftwareUpdate.
        The lifecycle state of the software update.

        Allowed values for this property are: "WAITING", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SoftwareUpdate.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SoftwareUpdate.
        The lifecycle state of the software update.


        :param lifecycle_state: The lifecycle_state of this SoftwareUpdate.
        :type: str
        """
        allowed_values = ["WAITING", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
