# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpstConfigurationDetails(object):
    """
    Details for activating/updating UPST config on the cluster
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpstConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vault_id:
            The value to assign to the vault_id property of this UpstConfigurationDetails.
        :type vault_id: str

        :param master_encryption_key_id:
            The value to assign to the master_encryption_key_id property of this UpstConfigurationDetails.
        :type master_encryption_key_id: str

        """
        self.swagger_types = {
            'vault_id': 'str',
            'master_encryption_key_id': 'str'
        }
        self.attribute_map = {
            'vault_id': 'vaultId',
            'master_encryption_key_id': 'masterEncryptionKeyId'
        }
        self._vault_id = None
        self._master_encryption_key_id = None

    @property
    def vault_id(self):
        """
        Gets the vault_id of this UpstConfigurationDetails.
        OCID of the vault to store token exchange service principal keyta, required for activating UPST config


        :return: The vault_id of this UpstConfigurationDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this UpstConfigurationDetails.
        OCID of the vault to store token exchange service principal keyta, required for activating UPST config


        :param vault_id: The vault_id of this UpstConfigurationDetails.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def master_encryption_key_id(self):
        """
        Gets the master_encryption_key_id of this UpstConfigurationDetails.
        OCID of the master encryption key in vault for encrypting token exchange service principal keytab, required for activating UPST config


        :return: The master_encryption_key_id of this UpstConfigurationDetails.
        :rtype: str
        """
        return self._master_encryption_key_id

    @master_encryption_key_id.setter
    def master_encryption_key_id(self, master_encryption_key_id):
        """
        Sets the master_encryption_key_id of this UpstConfigurationDetails.
        OCID of the master encryption key in vault for encrypting token exchange service principal keytab, required for activating UPST config


        :param master_encryption_key_id: The master_encryption_key_id of this UpstConfigurationDetails.
        :type: str
        """
        self._master_encryption_key_id = master_encryption_key_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
