# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkCreateOccmDemandSignalItemDetails(object):
    """
    Details about the model that is to be used for bulk creating demand signal items.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BulkCreateOccmDemandSignalItemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param demand_signal_id:
            The value to assign to the demand_signal_id property of this BulkCreateOccmDemandSignalItemDetails.
        :type demand_signal_id: str

        :param create_occm_demand_signal_items:
            The value to assign to the create_occm_demand_signal_items property of this BulkCreateOccmDemandSignalItemDetails.
        :type create_occm_demand_signal_items: list[oci.capacity_management.models.BulkCreateOccmDemandSignalItem]

        """
        self.swagger_types = {
            'demand_signal_id': 'str',
            'create_occm_demand_signal_items': 'list[BulkCreateOccmDemandSignalItem]'
        }
        self.attribute_map = {
            'demand_signal_id': 'demandSignalId',
            'create_occm_demand_signal_items': 'createOccmDemandSignalItems'
        }
        self._demand_signal_id = None
        self._create_occm_demand_signal_items = None

    @property
    def demand_signal_id(self):
        """
        **[Required]** Gets the demand_signal_id of this BulkCreateOccmDemandSignalItemDetails.
        The OCID of the demand signal in which we want to bulk create these demand signal item resources.


        :return: The demand_signal_id of this BulkCreateOccmDemandSignalItemDetails.
        :rtype: str
        """
        return self._demand_signal_id

    @demand_signal_id.setter
    def demand_signal_id(self, demand_signal_id):
        """
        Sets the demand_signal_id of this BulkCreateOccmDemandSignalItemDetails.
        The OCID of the demand signal in which we want to bulk create these demand signal item resources.


        :param demand_signal_id: The demand_signal_id of this BulkCreateOccmDemandSignalItemDetails.
        :type: str
        """
        self._demand_signal_id = demand_signal_id

    @property
    def create_occm_demand_signal_items(self):
        """
        **[Required]** Gets the create_occm_demand_signal_items of this BulkCreateOccmDemandSignalItemDetails.
        A list of demand signal items that we want to bulk create.


        :return: The create_occm_demand_signal_items of this BulkCreateOccmDemandSignalItemDetails.
        :rtype: list[oci.capacity_management.models.BulkCreateOccmDemandSignalItem]
        """
        return self._create_occm_demand_signal_items

    @create_occm_demand_signal_items.setter
    def create_occm_demand_signal_items(self, create_occm_demand_signal_items):
        """
        Sets the create_occm_demand_signal_items of this BulkCreateOccmDemandSignalItemDetails.
        A list of demand signal items that we want to bulk create.


        :param create_occm_demand_signal_items: The create_occm_demand_signal_items of this BulkCreateOccmDemandSignalItemDetails.
        :type: list[oci.capacity_management.models.BulkCreateOccmDemandSignalItem]
        """
        self._create_occm_demand_signal_items = create_occm_demand_signal_items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
