# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOccAvailabilityCatalogDetails(object):
    """
    Details about the create request for the availability catalog.
    """

    #: A constant which can be used with the namespace property of a CreateOccAvailabilityCatalogDetails.
    #: This constant has a value of "COMPUTE"
    NAMESPACE_COMPUTE = "COMPUTE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOccAvailabilityCatalogDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param occ_customer_group_id:
            The value to assign to the occ_customer_group_id property of this CreateOccAvailabilityCatalogDetails.
        :type occ_customer_group_id: str

        :param namespace:
            The value to assign to the namespace property of this CreateOccAvailabilityCatalogDetails.
            Allowed values for this property are: "COMPUTE"
        :type namespace: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOccAvailabilityCatalogDetails.
        :type compartment_id: str

        :param base64_encoded_catalog_details:
            The value to assign to the base64_encoded_catalog_details property of this CreateOccAvailabilityCatalogDetails.
        :type base64_encoded_catalog_details: str

        :param metadata_details:
            The value to assign to the metadata_details property of this CreateOccAvailabilityCatalogDetails.
        :type metadata_details: oci.capacity_management.models.MetadataDetails

        :param display_name:
            The value to assign to the display_name property of this CreateOccAvailabilityCatalogDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateOccAvailabilityCatalogDetails.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOccAvailabilityCatalogDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOccAvailabilityCatalogDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'occ_customer_group_id': 'str',
            'namespace': 'str',
            'compartment_id': 'str',
            'base64_encoded_catalog_details': 'str',
            'metadata_details': 'MetadataDetails',
            'display_name': 'str',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'occ_customer_group_id': 'occCustomerGroupId',
            'namespace': 'namespace',
            'compartment_id': 'compartmentId',
            'base64_encoded_catalog_details': 'base64EncodedCatalogDetails',
            'metadata_details': 'metadataDetails',
            'display_name': 'displayName',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._occ_customer_group_id = None
        self._namespace = None
        self._compartment_id = None
        self._base64_encoded_catalog_details = None
        self._metadata_details = None
        self._display_name = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def occ_customer_group_id(self):
        """
        **[Required]** Gets the occ_customer_group_id of this CreateOccAvailabilityCatalogDetails.
        The OCID of the customer group.


        :return: The occ_customer_group_id of this CreateOccAvailabilityCatalogDetails.
        :rtype: str
        """
        return self._occ_customer_group_id

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, occ_customer_group_id):
        """
        Sets the occ_customer_group_id of this CreateOccAvailabilityCatalogDetails.
        The OCID of the customer group.


        :param occ_customer_group_id: The occ_customer_group_id of this CreateOccAvailabilityCatalogDetails.
        :type: str
        """
        self._occ_customer_group_id = occ_customer_group_id

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this CreateOccAvailabilityCatalogDetails.
        The name of the OCI service in consideration. For example, Compute, Exadata, and so on.

        Allowed values for this property are: "COMPUTE"


        :return: The namespace of this CreateOccAvailabilityCatalogDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this CreateOccAvailabilityCatalogDetails.
        The name of the OCI service in consideration. For example, Compute, Exadata, and so on.


        :param namespace: The namespace of this CreateOccAvailabilityCatalogDetails.
        :type: str
        """
        allowed_values = ["COMPUTE"]
        if not value_allowed_none_or_none_sentinel(namespace, allowed_values):
            raise ValueError(
                f"Invalid value for `namespace`, must be None or one of {allowed_values}"
            )
        self._namespace = namespace

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOccAvailabilityCatalogDetails.
        Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.


        :return: The compartment_id of this CreateOccAvailabilityCatalogDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOccAvailabilityCatalogDetails.
        Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.


        :param compartment_id: The compartment_id of this CreateOccAvailabilityCatalogDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def base64_encoded_catalog_details(self):
        """
        **[Required]** Gets the base64_encoded_catalog_details of this CreateOccAvailabilityCatalogDetails.
        The base 64 encoded string corresponding to the catalog file contents.


        :return: The base64_encoded_catalog_details of this CreateOccAvailabilityCatalogDetails.
        :rtype: str
        """
        return self._base64_encoded_catalog_details

    @base64_encoded_catalog_details.setter
    def base64_encoded_catalog_details(self, base64_encoded_catalog_details):
        """
        Sets the base64_encoded_catalog_details of this CreateOccAvailabilityCatalogDetails.
        The base 64 encoded string corresponding to the catalog file contents.


        :param base64_encoded_catalog_details: The base64_encoded_catalog_details of this CreateOccAvailabilityCatalogDetails.
        :type: str
        """
        self._base64_encoded_catalog_details = base64_encoded_catalog_details

    @property
    def metadata_details(self):
        """
        Gets the metadata_details of this CreateOccAvailabilityCatalogDetails.

        :return: The metadata_details of this CreateOccAvailabilityCatalogDetails.
        :rtype: oci.capacity_management.models.MetadataDetails
        """
        return self._metadata_details

    @metadata_details.setter
    def metadata_details(self, metadata_details):
        """
        Sets the metadata_details of this CreateOccAvailabilityCatalogDetails.

        :param metadata_details: The metadata_details of this CreateOccAvailabilityCatalogDetails.
        :type: oci.capacity_management.models.MetadataDetails
        """
        self._metadata_details = metadata_details

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateOccAvailabilityCatalogDetails.
        The display name of the availability catalog.


        :return: The display_name of this CreateOccAvailabilityCatalogDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOccAvailabilityCatalogDetails.
        The display name of the availability catalog.


        :param display_name: The display_name of this CreateOccAvailabilityCatalogDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateOccAvailabilityCatalogDetails.
        Additional information about the availability catalog.


        :return: The description of this CreateOccAvailabilityCatalogDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateOccAvailabilityCatalogDetails.
        Additional information about the availability catalog.


        :param description: The description of this CreateOccAvailabilityCatalogDetails.
        :type: str
        """
        self._description = description

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOccAvailabilityCatalogDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateOccAvailabilityCatalogDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOccAvailabilityCatalogDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateOccAvailabilityCatalogDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOccAvailabilityCatalogDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateOccAvailabilityCatalogDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOccAvailabilityCatalogDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateOccAvailabilityCatalogDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
