# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdditionalConfigPropertyDefinition(object):
    """
    Detector rule additional property field
    """

    #: A constant which can be used with the property_type property of a AdditionalConfigPropertyDefinition.
    #: This constant has a value of "HINT"
    PROPERTY_TYPE_HINT = "HINT"

    #: A constant which can be used with the property_type property of a AdditionalConfigPropertyDefinition.
    #: This constant has a value of "RANGE"
    PROPERTY_TYPE_RANGE = "RANGE"

    def __init__(self, **kwargs):
        """
        Initializes a new AdditionalConfigPropertyDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param property_type:
            The value to assign to the property_type property of this AdditionalConfigPropertyDefinition.
            Allowed values for this property are: "HINT", "RANGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type property_type: str

        :param key:
            The value to assign to the key property of this AdditionalConfigPropertyDefinition.
        :type key: str

        :param value:
            The value to assign to the value property of this AdditionalConfigPropertyDefinition.
        :type value: str

        """
        self.swagger_types = {
            'property_type': 'str',
            'key': 'str',
            'value': 'str'
        }
        self.attribute_map = {
            'property_type': 'propertyType',
            'key': 'key',
            'value': 'value'
        }
        self._property_type = None
        self._key = None
        self._value = None

    @property
    def property_type(self):
        """
        Gets the property_type of this AdditionalConfigPropertyDefinition.
        Property Type

        Allowed values for this property are: "HINT", "RANGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The property_type of this AdditionalConfigPropertyDefinition.
        :rtype: str
        """
        return self._property_type

    @property_type.setter
    def property_type(self, property_type):
        """
        Sets the property_type of this AdditionalConfigPropertyDefinition.
        Property Type


        :param property_type: The property_type of this AdditionalConfigPropertyDefinition.
        :type: str
        """
        allowed_values = ["HINT", "RANGE"]
        if not value_allowed_none_or_none_sentinel(property_type, allowed_values):
            property_type = 'UNKNOWN_ENUM_VALUE'
        self._property_type = property_type

    @property
    def key(self):
        """
        Gets the key of this AdditionalConfigPropertyDefinition.
        Name for Additional Property, for example, \"interpreter\", \"router\"


        :return: The key of this AdditionalConfigPropertyDefinition.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this AdditionalConfigPropertyDefinition.
        Name for Additional Property, for example, \"interpreter\", \"router\"


        :param key: The key of this AdditionalConfigPropertyDefinition.
        :type: str
        """
        self._key = key

    @property
    def value(self):
        """
        Gets the value of this AdditionalConfigPropertyDefinition.
        Value for Property Name, for example, \"generic\", \"cloudguard\"


        :return: The value of this AdditionalConfigPropertyDefinition.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AdditionalConfigPropertyDefinition.
        Value for Property Name, for example, \"generic\", \"cloudguard\"


        :param value: The value of this AdditionalConfigPropertyDefinition.
        :type: str
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
